﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Assert.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_Common.h>
#include <nn/result/result_HandlingUtility.h>

#include <nn/netdiag/netdiag_BandWidthApi.h>
#include <nn/netdiag/netdiag_BandWidthTypes.h>
#include <nn/netdiag/netdiag_BandWidthTypesPrivate.h>
#include <nn/netdiag/netdiag_Result.h>
#include <nn/netdiag/detail/netdiag_BandWidthMeasuring.h>

namespace nn { namespace netdiag {

Result MeasureBandWidthForUpload( BandWidth* pBandWidth, uint32_t timeOut ) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL( pBandWidth );
    return detail::MeasureBandWidthForUpload( pBandWidth, timeOut, NULL );
}

Result MeasureBandWidthForUpload( BandWidth* pBandWidth, uint32_t timeOut, bool* pIsTimedout ) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL( pBandWidth );
    return detail::MeasureBandWidthForUpload( pBandWidth, timeOut, pIsTimedout );
}

Result MeasureBandWidthForDownload( BandWidth* pBandWidth, uint32_t timeOut ) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL( pBandWidth );
    return detail::MeasureBandWidthForDownload( pBandWidth, timeOut, NULL );
}

Result MeasureBandWidthForDownload( BandWidth* pBandWidth, uint32_t timeOut, bool* pIsTimedout ) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL( pBandWidth );
    return detail::MeasureBandWidthForDownload( pBandWidth, timeOut, pIsTimedout );
}

void InterruptMeasureBandWidth() NN_NOEXCEPT
{
    detail::InterruptMeasureBandWidth();
}

}} // nn::netdiag
