﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fgm.h>
#include <nn/util/util_PlacementArray.h>

#include "mmnv_RequestImpl.h"

namespace nn     {
namespace mmnv   {
namespace server {

typedef RequestImpl Owner;

class RequestSet
{
private:
    nn::fgm::Request m_FgmRequest;
    Owner* m_Owner; // RequestImpl インスタンスのポインタを利用

public:
    bool IsFree()       { return m_Owner == nullptr;  }
    void Clear()        { m_Owner = nullptr; }
    void SetOwner(Owner* owner) { m_Owner = owner; }
    Owner* GetOwner() { return m_Owner; }
    nn::fgm::Request& FgmRequest() { return m_FgmRequest; }
    RequestSet() :
        m_Owner(nullptr)
    { }
};

// for compatibility with NX Addon 0.12.x
class RequestSetOld : public RequestSet
{
private:
    nn::mmnv::Module m_ModuleId;

public:
    RequestSetOld()
    {
    }
    void SetModuleId(nn::mmnv::Module id)
    {
        m_ModuleId = id;
    }

    bool IsSameModule(nn::mmnv::Module id) const
    {
        return (m_ModuleId == id);
    }
};

class RequestManager
{
private:
    static const int  MaxNumRequestSet = 40;
    RequestSet m_RequestSet[MaxNumRequestSet];

    // for compatilibity with NX Addon 0.12.x
    static const int  MaxNumRequsetSetForCompatibility = 5;
    RequestSetOld     m_RequestSetForCompatibility[MaxNumRequsetSetForCompatibility];

public:
    nn::Result AcquireRequestId(std::int32_t* pRequesId, nn::mmnv::Module moduleId, nn::os::EventClearMode eventClearMode, Owner* owner) NN_NOEXCEPT;
    nn::Result ReleaseRequestId(std::int32_t requestId) NN_NOEXCEPT;
    nn::Result ReleaseOwnRequestIds(Owner* owner) NN_NOEXCEPT;
    nn::Result SetAndWait(std::int32_t requestId, std::uint32_t min, std::uint32_t max) NN_NOEXCEPT;
    nn::Result Get(std::uint32_t* pSetting, std::int32_t requestId) NN_NOEXCEPT;
    RequestManager() NN_NOEXCEPT;

    // for compatilibity with NX Addon 0.12.x
    nn::Result InitializeRequest(nn::mmnv::Module moduleId, nn::os::EventClearMode eventClearMode, Owner* owner) NN_NOEXCEPT;
    nn::Result FinalizeRequest(nn::mmnv::Module moduleId) NN_NOEXCEPT;
    nn::Result ReleaseOwnRequestIdsForCompatibility(Owner* owner) NN_NOEXCEPT;
    nn::Result SetAndWait(nn::mmnv::Module moduleId, std::uint32_t min, std::uint32_t max) NN_NOEXCEPT;
    nn::Result Get(std::uint32_t* pSetting, nn::mmnv::Module moduleId) NN_NOEXCEPT;
};

}}}
