﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "mmnv_CreateRequest.h"

#include <nn/mmnv/sfdl/mmnv.sfdl.h>
#include "mmnv_ServiceName.h"
#include <nn/sf/sf_HipcClientProxyByName.h>
#include <nn/sf/sf_ExpHeapAllocator.h>
#include <nn/nn_Abort.h>

namespace nn   {
namespace mmnv {

namespace {

struct CreateRequestByHipcTag;
typedef nn::sf::ExpHeapStaticAllocator<1024 * 16, CreateRequestByHipcTag> MyAllocator;

class MyAllocatorInitializer
{
public:
    MyAllocatorInitializer() NN_NOEXCEPT
    {
        MyAllocator::Initialize(nn::lmem::CreationOption_NoOption);
    }
} g_MyAllocatorInitializer;

}

nn::sf::SharedPointer<IRequest> CreateRequestByHipc() NN_NOEXCEPT
{
    nn::sf::SharedPointer<IRequest> ret;
    auto result = nn::sf::CreateHipcProxyByName<IRequest, MyAllocator::Policy>(&ret, MmnvRequestServiceName);
    NN_ABORT_UNLESS(result.IsSuccess());
    return ret;
}

}}

