﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/mii/detail/service/mii_StaticServiceInterface.h>

#include <nn/mii/detail/service/mii_ServiceProvider.h>
#include <nn/mii/detail/service/mii_DatabaseServiceInterface.h>
#include <nn/mii/detail/service/mii_IDatabaseService.sfdl.h>
#include <nn/mii/mii_Result.h>

#include <nn/sf/sf_ObjectFactory.h>
#include <nn/result/result_HandlingUtility.h>


namespace nn
{
namespace mii
{
namespace detail
{

StaticServiceInterface::StaticServiceInterface(
    ServiceProvider* pServiceProvider,
    nn::sf::ExpHeapAllocator* pExpHeapAllocator,
    bool isEditor
) NN_NOEXCEPT
    : m_pServiceProvider(pServiceProvider),
      m_pExpHeapAllocator(pExpHeapAllocator),
      m_IsEditor(isEditor)
{
}

StaticServiceInterface::~StaticServiceInterface() NN_NOEXCEPT
{
}

nn::Result StaticServiceInterface::GetDatabaseService(nn::sf::Out<nn::sf::SharedPointer<IDatabaseService>> outIDatabaseService, int specialMiiKeyCode) NN_NOEXCEPT
{
    auto pIDatabaseService =
        nn::sf::ObjectFactory<nn::sf::ExpHeapAllocator::Policy>::CreateSharedEmplaced<IDatabaseService, DatabaseServiceInterface>(
            m_pExpHeapAllocator, &m_pServiceProvider->m_DatabaseImpl, specialMiiKeyCode, m_IsEditor
        );

    NN_RESULT_THROW_UNLESS(pIDatabaseService != nullptr, ResultInvalid());

    outIDatabaseService.Set(pIDatabaseService);

    NN_RESULT_SUCCESS;
}

}
}
}
