﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/mii/detail/service/mii_ServiceProviderClient.h>
#include <nn/mii/detail/service/mii_ServiceNames.h>
#include <nn/mii/detail/service/mii_IStaticService.sfdl.h>
#include <nn/mii/detail/service/mii_IDatabaseService.sfdl.h>
#include <nn/mii/mii_ApiServer.h>

#include <nn/sf/sf_ShimLibraryUtility.h>

namespace nn
{
namespace mii
{
namespace detail
{

ServiceProviderClient g_ServiceProviderClient;

#if NN_DETAIL_MII_CONFIG_SERVICE_FRAMEWORK_MODEL == NN_DETAIL_MII_CONFIG_SERVICE_FRAMEWORK_MODEL_HIPC
namespace
{
    nn::sf::SimpleAllInOneHipcSubDomainClientManager<16> g_Manager = NN_SF_SIMPLE_ALL_IN_ONE_HIPC_SUB_DOMAIN_CLIENT_MANAGER_INITIALIZER;
    nn::sf::ShimLibraryObjectHolder<detail::IStaticService> g_Holder = NN_SF_SHIM_LIBRARY_OBJECT_HOLDER_INITIALIZER;
}
#endif

nn::Result ServiceProviderClient::Initialize() NN_NOEXCEPT
{
#if NN_DETAIL_MII_CONFIG_SERVER_MODEL == NN_DETAIL_MII_CONFIG_SERVER_MODEL_THREAD
    NN_RESULT_DO(RegisterServer());
#if NN_DETAIL_MII_CONFIG_SERVICE_FRAMEWORK_MODEL == NN_DETAIL_MII_CONFIG_SERVICE_FRAMEWORK_MODEL_HIPC
    NN_RESULT_DO(StartServer());
#endif
#endif

#if NN_DETAIL_MII_CONFIG_SERVICE_FRAMEWORK_MODEL == NN_DETAIL_MII_CONFIG_SERVICE_FRAMEWORK_MODEL_HIPC
    if (!m_IsInitialized)
    {
        auto result = g_Manager.InitializeShimLibraryHolder(&g_Holder, detail::EditorServiceName);

        if (result.IsFailure())
        {
            result = g_Manager.InitializeShimLibraryHolder(&g_Holder, detail::UserServiceName);
        }

        NN_RESULT_DO(result);

        m_IsInitialized = true;
    }
#endif

    NN_RESULT_SUCCESS;
}

nn::Result ServiceProviderClient::GetDatabaseServiceSharedPointer(nn::sf::SharedPointer<detail::IDatabaseService>* ppDatabaseService, int specialMiiKeyCode) NN_NOEXCEPT
{
#if NN_DETAIL_MII_CONFIG_SERVICE_FRAMEWORK_MODEL == NN_DETAIL_MII_CONFIG_SERVICE_FRAMEWORK_MODEL_DFC
    ServiceProvider* pServiceProvider = GetServiceProviderPointer();
    NN_SDK_ASSERT_NOT_NULL(pServiceProvider);
    return pServiceProvider->m_HipcServerManager.GetEditorStaticService().GetDatabaseService(ppDatabaseService, specialMiiKeyCode);
#elif NN_DETAIL_MII_CONFIG_SERVICE_FRAMEWORK_MODEL == NN_DETAIL_MII_CONFIG_SERVICE_FRAMEWORK_MODEL_HIPC
    NN_SDK_ASSERT(m_IsInitialized, "ServiceProviderClient::Initialize() not called.");
    return g_Holder.GetObject()->GetDatabaseService(ppDatabaseService, specialMiiKeyCode);
#endif
}

void ServiceProviderClient::Finalize() NN_NOEXCEPT
{
#if NN_DETAIL_MII_CONFIG_SERVICE_FRAMEWORK_MODEL == NN_DETAIL_MII_CONFIG_SERVICE_FRAMEWORK_MODEL_HIPC
    g_Holder.FinalizeHolder();
#endif
}

}
}
}
