﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/mii/detail/service/mii_ServiceProvider.h>

#include <nn/mii/mii_Special.h>
#include <nn/mii/mii_SpecialCommon.h>

#include <nn/result/result_HandlingUtility.h>


namespace nn
{
namespace mii
{
namespace detail
{

ServiceProvider::GeneralArranger::GeneralArranger() NN_NOEXCEPT
{
    // 各コンポーネントの初期化前に必要な処理をここに書く
}

ServiceProvider::GeneralArranger::~GeneralArranger() NN_NOEXCEPT
{
}

ServiceProvider::ServiceProvider() NN_NOEXCEPT
    : m_GeneralArranger(),
      m_HipcServerManager(this),
      m_ImageDatabaseImpl()
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::mii::detail::MountImageDatabase(true));
    NN_ABORT_UNLESS_RESULT_SUCCESS(m_DatabaseImpl.Initialize(&m_DatabaseImplStorage, sizeof(m_DatabaseImplStorage)));
}

ServiceProvider::~ServiceProvider() NN_NOEXCEPT
{
    nn::mii::detail::UnmountImageDatabase();
}

nn::Result ServiceProvider::Start() NN_NOEXCEPT
{
#if NN_DETAIL_MII_CONFIG_SERVICE_FRAMEWORK_MODEL == NN_DETAIL_MII_CONFIG_SERVICE_FRAMEWORK_MODEL_HIPC
    m_HipcServerManager.LoopAuto();

    // TODO:終了処理
    // ...
#endif

    NN_RESULT_SUCCESS;
}

nn::Result ServiceProvider::RequestStopServer() NN_NOEXCEPT
{
#if NN_DETAIL_MII_CONFIG_SERVICE_FRAMEWORK_MODEL == NN_DETAIL_MII_CONFIG_SERVICE_FRAMEWORK_MODEL_HIPC
    m_HipcServerManager.RequestStop();
#endif

    NN_RESULT_SUCCESS;
}

}
}
}
