﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>
#include "lm_LogGetterImpl.h"

namespace nn { namespace lm { namespace impl {

const uint8_t *LogGetterImpl::m_pMessage;
size_t LogGetterImpl::m_BufferSize = 0;
size_t LogGetterImpl::m_LogPacketDropCount = 0;

bool LogGetterImpl::FlushFunc(const uint8_t* message, size_t messageSize) NN_NOEXCEPT
{
    m_pMessage = message;
    m_BufferSize = messageSize;
    return true;
}

CustomSinkBuffer& LogGetterImpl::GetBuffer() NN_NOEXCEPT
{
    NN_FUNCTION_LOCAL_STATIC(std::aligned_storage<32 * 1024>::type, storage);
    NN_FUNCTION_LOCAL_STATIC(CustomSinkBuffer, instance, (&storage, sizeof(storage), FlushFunc));
    return instance;
}

int64_t LogGetterImpl::GetLog(char* buffer, size_t bufferSize, uint32_t* dropCount) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(buffer);

    auto minBufferSize = m_BufferSize;

    if (bufferSize < m_BufferSize)
    {
        minBufferSize = bufferSize;
        IncreaseLogPacketDropCount();
    }

    memcpy(buffer, m_pMessage, minBufferSize);

    *dropCount = static_cast<uint32_t>(m_LogPacketDropCount);
    m_LogPacketDropCount = 0;
    return minBufferSize;
}

}}} // nn::lm::impl
