﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os/os_LightEvent.h>

namespace nn { namespace lm { namespace impl {

// @brief   ログを一時的に格納するためのバッファです。
// @detail  引数に与えられた配列を、ログ格納用のバッファとして使用します。
//          バッファはシングルバッファリングで実装されています。
//
//          マルチスレッドでの書き込みとフラッシュには対応していません。
class CustomSinkBuffer
{
    NN_DISALLOW_COPY( CustomSinkBuffer );
    NN_DISALLOW_MOVE( CustomSinkBuffer );

public:
    typedef bool (*FlushFunction)(const uint8_t* buffer, size_t bufferSize);

    explicit CustomSinkBuffer(void* buffer, size_t bufferSize, FlushFunction function) NN_NOEXCEPT;

    bool TryPush(const void* pSrc, size_t srcSize) NN_NOEXCEPT;
    bool TryFlush() NN_NOEXCEPT;

private:
    uint8_t* m_Buffer;
    size_t   m_BufferSize;
    size_t   m_UsedBufferSize;

    FlushFunction m_FlushFunction;
};

}}} // nn::lm::impl
