﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "lm_LogDataChunk.h"
#include "lm_LogPacketHeader.h"

namespace nn { namespace lm { namespace detail {

class LogPacketTransmitterBase
{
public:
    typedef bool (*FlushFunction)(const uint8_t* data, size_t size);

protected:
    LogPacketTransmitterBase(
        void*           buffer,
        size_t          bufferSize,
        FlushFunction   function,
        uint8_t         severity,
        uint8_t         verbosity,
        uint64_t        processId,
        bool            isHead,
        bool            isTail) NN_NOEXCEPT;
    ~LogPacketTransmitterBase() NN_NOEXCEPT;
    void PushDataChunk(LogDataChunkKey key, const void* data, size_t dataSize) NN_NOEXCEPT;

public:
    /*!
        @brief    バッファのログをフラッシュします。

        @param[in]    isTail        最後のパケットか。

        @return   フラッシュに成功したときは true。

        @details
                  フラッシュの成功および失敗に関わらず、
                  バッファの内容が破棄されることに注意してください。
    */
    bool Flush(bool isTail) NN_NOEXCEPT;

private:
    void PushUleb128(unsigned int value) NN_NOEXCEPT;
    void Push(const void* data, size_t dataSize) NN_NOEXCEPT;

    LogPacketHeader* m_pHeader;

    uint8_t*  m_pBegin;
    uint8_t*  m_pEnd;
    uint8_t*  m_pPayload;
    uint8_t*  m_pCurrent;

    bool      m_IsTail;

    FlushFunction m_FlushFunction;
};

}}} // nn::lm::detail
