﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "lm_LogPacketTransmitterBase.h"

namespace nn { namespace lm { namespace detail {

class LogPacketTransmitter : public LogPacketTransmitterBase
{
public:
    LogPacketTransmitter(
        void*           buffer,
        size_t          bufferSize,
        FlushFunction   function,
        uint8_t         severity,
        uint8_t         verbosity,
        uint64_t        processId,
        bool            isHead,
        bool            isTail) NN_NOEXCEPT;

    void PushLogSessionBegin() NN_NOEXCEPT;
    void PushLogSessionEnd() NN_NOEXCEPT;
    void PushTextLog(const char* text, size_t length) NN_NOEXCEPT;
    void PushLineNumber(uint32_t lineNumber) NN_NOEXCEPT;
    void PushFileName(const char* text, size_t length) NN_NOEXCEPT;
    void PushFunctionName(const char* text, size_t length) NN_NOEXCEPT;
    void PushModuleName(const char* text, size_t length) NN_NOEXCEPT;
    void PushThreadName(const char* text, size_t length) NN_NOEXCEPT;
    void PushLogPacketDropCount(uint64_t count) NN_NOEXCEPT;
    void PushUserSystemClock(int64_t posixTime) NN_NOEXCEPT;
    void PushProcessName(const char* text, size_t length) NN_NOEXCEPT;
};

}}} // nn::lm::detail
