﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <nn/os.h>
#include "lm_LogPacketTransmitter.h"

extern "C" void nnMain();

namespace nn { namespace lm { namespace detail {

LogPacketTransmitter::LogPacketTransmitter(
    void*           buffer,
    size_t          bufferSize,
    FlushFunction   function,
    uint8_t         severity,
    uint8_t         verbosity,
    uint64_t        processId,
    bool            isHead,
    bool            isTail) NN_NOEXCEPT
    : LogPacketTransmitterBase(
        buffer, bufferSize, function, severity, verbosity, processId, isHead, isTail)
{
}

void LogPacketTransmitter::PushLogSessionBegin() NN_NOEXCEPT
{
    auto value = true;
    PushDataChunk(
        LogDataChunkKey_LogSessionBegin, &value, sizeof(value));
}

void LogPacketTransmitter::PushLogSessionEnd() NN_NOEXCEPT
{
    auto value = true;
    PushDataChunk(
        LogDataChunkKey_LogSessionEnd, &value, sizeof(value));
}

void LogPacketTransmitter::PushTextLog(const char* text, size_t length) NN_NOEXCEPT
{
    PushDataChunk(
        LogDataChunkKey_TextLog, text, length);
}

void LogPacketTransmitter::PushLineNumber(uint32_t lineNumber) NN_NOEXCEPT
{
    PushDataChunk(
        LogDataChunkKey_LineNumber, &lineNumber, sizeof(lineNumber));
}

void LogPacketTransmitter::PushFileName(const char* text, size_t length) NN_NOEXCEPT
{
    PushDataChunk(
        LogDataChunkKey_FileName, text, length);
}

void LogPacketTransmitter::PushFunctionName(const char* text, size_t length) NN_NOEXCEPT
{
    PushDataChunk(
        LogDataChunkKey_FunctionName, text, length);
}

void LogPacketTransmitter::PushModuleName(const char* text, size_t length) NN_NOEXCEPT
{
    PushDataChunk(
        LogDataChunkKey_ModuleName, text, length);
}

void LogPacketTransmitter::PushThreadName(const char* text, size_t length) NN_NOEXCEPT
{
    PushDataChunk(
        LogDataChunkKey_ThreadName, text, length);
}

void LogPacketTransmitter::PushLogPacketDropCount(uint64_t count) NN_NOEXCEPT
{
    PushDataChunk(
        LogDataChunkKey_LogPacketDropCount, &count, sizeof(count));
}

void LogPacketTransmitter::PushUserSystemClock(int64_t posixTime) NN_NOEXCEPT
{
    PushDataChunk(
        LogDataChunkKey_UserSystemClock, &posixTime, sizeof(posixTime));
}

void LogPacketTransmitter::PushProcessName(const char* text, size_t length) NN_NOEXCEPT
{
    PushDataChunk(
        LogDataChunkKey_ProcessName, text, length);
}

}}} // nn::lm::detail
