﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>
#include <nn/lmem/lmem_ExpHeap.h>

#include <nn/lbl/impl/lbl.h>
#include <nn/lbl/impl/lbl_Mapping.h>
#include <nn/lbl/impl/lbl_SettingsForVrMode.h>
#include <nn/lbl/impl/lbl_Switch.h>
#include <nn/lbl/impl/lbl_VrMode.h>

#include <nn/lbl/detail/lbl_ILblController.h>
#include "../detail/lbl_ServiceType.h"

#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/sf_NativeHandle.h>

#include "lbl_LblControllerImpl.h"

namespace nn { namespace lbl { namespace server {

// ここから各 LBL API の内部実装
LblControllerImpl::LblControllerImpl() NN_NOEXCEPT
{
}

LblControllerImpl::~LblControllerImpl() NN_NOEXCEPT
{
}

void LblControllerImpl::SaveCurrentSetting() NN_NOEXCEPT
{
    nn::lbl::impl::SaveCurrentSetting();
}

void LblControllerImpl::LoadCurrentSetting() NN_NOEXCEPT
{
    nn::lbl::impl::LoadCurrentSetting();
}

void LblControllerImpl::SetCurrentBrightnessSetting(float brightnessSetting) NN_NOEXCEPT
{
    nn::lbl::impl::SetCurrentBrightnessSetting(brightnessSetting);
}

float LblControllerImpl::GetCurrentBrightnessSetting() NN_NOEXCEPT
{
    return nn::lbl::impl::GetCurrentBrightnessSetting();
}

void LblControllerImpl::SetCurrentBrightnessSettingForVrMode(float brightnessSetting) NN_NOEXCEPT
{
    nn::lbl::impl::SetCurrentBrightnessSettingForVrMode(brightnessSetting);
}

float LblControllerImpl::GetCurrentBrightnessSettingForVrMode() NN_NOEXCEPT
{
    return nn::lbl::impl::GetCurrentBrightnessSettingForVrMode();
}

void LblControllerImpl::ApplyCurrentBrightnessSettingToBacklight() NN_NOEXCEPT
{
    nn::lbl::impl::ApplyCurrentBrightnessSettingToBacklight();
}

float LblControllerImpl::GetBrightnessSettingAppliedToBacklight() NN_NOEXCEPT
{
    return nn::lbl::impl::GetBrightnessSettingAppliedToBacklight();
}

void LblControllerImpl::SwitchBacklightOn(nn::TimeSpan fadeInTime) NN_NOEXCEPT
{
    nn::lbl::impl::SwitchBacklightOn(fadeInTime);
}

void LblControllerImpl::SwitchBacklightOff(nn::TimeSpan fadeOutTime) NN_NOEXCEPT
{
    nn::lbl::impl::SwitchBacklightOff(fadeOutTime);
}

std::int32_t LblControllerImpl::GetBacklightSwitchStatus() NN_NOEXCEPT
{
    return nn::lbl::impl::GetBacklightSwitchStatus();
}

void LblControllerImpl::EnableDimming() NN_NOEXCEPT
{
    nn::lbl::impl::EnableDimming();
}

void LblControllerImpl::DisableDimming() NN_NOEXCEPT
{
    nn::lbl::impl::DisableDimming();
}

bool LblControllerImpl::IsDimmingEnabled() NN_NOEXCEPT
{
    return nn::lbl::impl::IsDimmingEnabled();
}

void LblControllerImpl::EnableVrMode() NN_NOEXCEPT
{
    nn::lbl::impl::EnableVrMode();
}

void LblControllerImpl::DisableVrMode() NN_NOEXCEPT
{
    nn::lbl::impl::DisableVrMode();
}

bool LblControllerImpl::IsVrModeEnabled() NN_NOEXCEPT
{
    return nn::lbl::impl::IsVrModeEnabled();
}

void LblControllerImpl::EnableAutoBrightnessControl() NN_NOEXCEPT
{
    nn::lbl::impl::EnableAutoBrightnessControl();
}

void LblControllerImpl::DisableAutoBrightnessControl() NN_NOEXCEPT
{
    nn::lbl::impl::DisableAutoBrightnessControl();
}

bool LblControllerImpl::IsAutoBrightnessControlEnabled() NN_NOEXCEPT
{
    return nn::lbl::impl::IsAutoBrightnessControlEnabled();
}

void LblControllerImpl::SetAmbientLightSensorValue(float sensorValue) NN_NOEXCEPT
{
    nn::lbl::impl::SetAmbientLightSensorValue(sensorValue);
}

float LblControllerImpl::GetAmbientLightSensorValue(nn::sf::Out<bool> outOverflowAlert) NN_NOEXCEPT
{
    return nn::lbl::impl::GetAmbientLightSensorValue(outOverflowAlert.GetPointer());
}

bool LblControllerImpl::IsAmbientLightSensorAvailable() NN_NOEXCEPT
{
    return nn::lbl::impl::IsAmbientLightSensorAvailable();
}

// 現在は使用されていない機能。バイナリ互換性のためしばらく残しておく
void LblControllerImpl::SetBrightnessReflectionDelayLevel(std::int32_t direction, float delayLevel) NN_NOEXCEPT
{
    NN_UNUSED(direction);
    NN_UNUSED(delayLevel);
    // nn::lbl::impl::SetBrightnessReflectionDelayLevel(static_cast<BrightnessChangeDirection>(direction), delayLevel)
}

// 現在は使用されていない機能。バイナリ互換性のためしばらく残しておく
float LblControllerImpl::GetBrightnessReflectionDelayLevel(std::int32_t direction) NN_NOEXCEPT
{
    NN_UNUSED(direction);
    return 0.0f;
    // return nn::lbl::impl::GetBrightnessReflectionDelayLevel(static_cast<BrightnessChangeDirection>(direction));
}

// 現在は使用されていない機能。バイナリ互換性のためしばらく残しておく
void LblControllerImpl::SetCurrentBrightnessMapping(MappingCoefficient brightnessMapping) NN_NOEXCEPT
{
    NN_UNUSED(brightnessMapping);
    // nn::lbl::impl::SetCurrentBrightnessMapping(brightnessMapping);
}

// 現在は使用されていない機能。バイナリ互換性のためしばらく残しておく
void LblControllerImpl::GetCurrentBrightnessMapping(nn::sf::Out<MappingCoefficient> brightnessMapping) NN_NOEXCEPT
{
    NN_UNUSED(brightnessMapping);
    // nn::lbl::impl::GetCurrentBrightnessMapping(brightnessMapping.GetPointer());
}

// 現在は使用されていない機能。バイナリ互換性のためしばらく残しておく
void LblControllerImpl::SetCurrentAmbientLightSensorMapping(MappingCoefficient sensorMapping) NN_NOEXCEPT
{
    NN_UNUSED(sensorMapping);
    // nn::lbl::impl::SetCurrentAmbientLightSensorMapping(sensorMapping);
}

// 現在は使用されていない機能。バイナリ互換性のためしばらく残しておく
void LblControllerImpl::GetCurrentAmbientLightSensorMapping(nn::sf::Out<MappingCoefficient> sensorMapping) NN_NOEXCEPT
{
    NN_UNUSED(sensorMapping);
    // nn::lbl::impl::GetCurrentAmbientLightSensorMapping(sensorMapping.GetPointer());
}

}}}
