﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os.h>
#include "idle_PolicyParam.h"

namespace nn { namespace idle { namespace server {

class HandlerImpl
{
public:
    void Initialize() NN_NOEXCEPT;
    void Enable() NN_NOEXCEPT;
    void Disable() NN_NOEXCEPT;
    void UpdatePolicy(const PolicyParam& policyParam) NN_NOEXCEPT;
    void NotifyActivity() NN_NOEXCEPT;
    void NotifyInactivity(const nn::TimeSpan& elapsedIdleTime) NN_NOEXCEPT;
    nn::os::SystemEventType* GetAutoPowerDownEvent() NN_NOEXCEPT;
    bool IsAutoPowerDownOn() NN_NOEXCEPT;
    bool IsDimmingOn() NN_NOEXCEPT;
};

}}} // namespace nn::idle::server

