﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_DeviceCode.h>

#include <nn/devicecode/devicecode_Predefined.i2c.h>

namespace nn { namespace i2c { namespace driver {

const nn::DeviceCode Gen1DeviceNameConvertTable[] =
{
    NN_DEVICECODE_HID_DEBUG_PAD,
    NN_DEVICECODE_HID_TOUCH_PANEL,
    NN_DEVICECODE_THERMAL_MONITOR_BOARD,
    NN_DEVICECODE_THERMAL_MONITOR_BOARD,
    NN_DEVICECODE_AUDIO_CODEC_BOARD,
    NN_DEVICECODE_RTC_BOARD,
    NN_DEVICECODE_REGULATOR_BOARD,
    NN_DEVICECODE_REGULATOR_CPU,
    NN_DEVICECODE_REGULATOR_GPU,
    NN_DEVICECODE_POWER_CONTROLLER_CHARGER,
    NN_DEVICECODE_POWER_CONTROLLER_FUEL_GAUGE,
    NN_DEVICECODE_POWER_DELIVERY_BOARD,
    NN_DEVICECODE_POWER_MONITOR_HOST_BRIDGE,
    NN_DEVICECODE_POWER_MONITOR_CPU,
    NN_DEVICECODE_POWER_MONITOR_GPU,
    NN_DEVICECODE_POWER_MONITOR_DRAM,
    NN_DEVICECODE_POWER_MONITOR_VSYSAP,
    NN_DEVICECODE_POWER_MONITOR_BACK_LIGHT,
    NN_DEVICECODE_LIGHT_SENSOR_AMBIENT,
    NN_DEVICECODE_POWER_MONITOR_CORE,
    NN_DEVICECODE_POWER_MONITOR_SOC_1V8,
    NN_DEVICECODE_POWER_MONITOR_DRAM_1V8,
    NN_DEVICECODE_POWER_MONITOR_REGULATOR_1V32,
    NN_DEVICECODE_POWER_MONITOR_VSYS_3V3,
    NN_DEVICECODE_AV_HDMI_DDC,
    NN_DEVICECODE_AV_HDMI_SCDC,
    NN_DEVICECODE_AV_HDMI_HDCP,
    NN_DEVICECODE_REGULATOR_DRAM,
    NN_DEVICECODE_REGULATOR_CPU_GPU,
    NN_DEVICECODE_REGULATOR_CPU_GPU,
    NN_DEVICECODE_POWER_MONITOR_DRAM_0V6,
};

const int Gen1DeviceNameConvertTableLength = NN_ARRAY_SIZE(Gen1DeviceNameConvertTable);

}}} // nn::i2c::driver
