﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/util/util_BitPack.h>

namespace nn {
namespace i2c {
namespace detail {

/**
 * @brief コマンド ID
 */
enum CommandId
{
    CommandId_Send      = 0x00,
    CommandId_Receive   = 0x01,
    CommandId_Extension = 0x02,
    CommandId_CountMax  = 0x03,
};

/**
 * @brief サブコマンド ID
 */
enum SubCommandId
{
    SubCommandId_Sleep   = 0x00,
};

/**
 * @brief 共通のコマンドフォーマット
 */
struct CommonCommandFormat
{
    typedef nn::util::BitPack8::Field< 0, 2, int > CommandHeader;    // byte1
    typedef nn::util::BitPack8::Field< 2, 6, int > SubCommandHeader; // byte1
};

/**
 * @brief Receive 向けコマンドフォーマット
 */
struct ReceiveCommandFormat
{
    typedef nn::util::BitPack8::Field< 7, 1, bool> StopCondition;    // byte1
    typedef nn::util::BitPack8::Field< 6, 1, bool> StartCondition;   // byte1
    typedef nn::util::BitPack8::Field< 0, 8, int>  DataBytes;        // byte2
};

/**
 * @brief Send 向けコマンドフォーマット
 */
struct SendCommandFormat
{
    typedef nn::util::BitPack8::Field< 7, 1, bool> StopCondition;     // byte1
    typedef nn::util::BitPack8::Field< 6, 1, bool> StartCondition;    // byte1
    typedef nn::util::BitPack8::Field< 0, 8, int>  DataBytes;         // byte2
};

/**
 * @brief Sleep 向けコマンドフォーマット
 */
struct SleepCommandFormat
{
    typedef nn::util::BitPack8::Field< 0, 8, int>  SleepMicroSeconds; // byte2
};

} // detail
} // i2c
} // nn
