﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// このファイルはユーザ定義

#include <nn/tma/detail/htcs_ServiceName.h>

#include <nn/sf/sf_HipcClient.h>
#include <nn/sf/sf_HipcClientProxyByName.h>
#include <nn/sf/sf_ExpHeapAllocator.h>
#include "htcs_HtcsManagerByHipc.h"

namespace nn { namespace htcs {

namespace {

// 拡張ヒープを使用したアロケータを、HIPC プロキシ用に準備
struct CreateTmaManagerByHipcTag;
typedef nn::sf::ExpHeapStaticAllocator<1024 * 16, CreateTmaManagerByHipcTag> MyAllocator;

// MyAllocator を静的コンストラクタで初期化するためのヘルパー
class MyAllocatorInitializer
{
public:

    MyAllocatorInitializer() NN_NOEXCEPT
    {
        MyAllocator::Initialize(nn::lmem::CreationOption_ThreadSafe);
    }

} g_MyAllocatorInitializer;
}

nn::sf::SharedPointer<nn::tma::IHtcsManager> CreateHtcsManagerByHipc() NN_NOEXCEPT
{
    nn::sf::SharedPointer<nn::tma::IHtcsManager> ret;
    auto result = nn::sf::CreateHipcProxyByName<nn::tma::IHtcsManager, MyAllocator::Policy>(&ret, nn::tma::detail::HtcsServiceName);
    NN_ABORT_UNLESS(result.IsSuccess());
    return ret;
}

nn::sf::SharedPointer<nn::tma::IHtcsManager> CreateHtcsManagerByHipc(nn::sf::HipcSimpleClientSessionManager* sessionManager) NN_NOEXCEPT
{
    nn::sf::SharedPointer<nn::tma::IHtcsManager> ret;
    auto result = sessionManager->InitializeByName<nn::tma::IHtcsManager, MyAllocator::Policy>(&ret, nn::tma::detail::HtcsServiceName);
    NN_ABORT_UNLESS(result.IsSuccess());
    return ret;
}

}}
