﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/os.h>

#include "htclow_Allocator.h"
#include "htclow_PacketFactory.h"

#include "driver/htclow_IDriver.h"
#include "mux/htclow_Mux.h"

namespace nn { namespace htclow { namespace server {

class Worker final
{
    NN_DISALLOW_COPY(Worker);
    NN_DISALLOW_MOVE(Worker);

public:
    explicit Worker(mux::Mux* pMux) NN_NOEXCEPT;
    ~Worker() NN_NOEXCEPT;

    void Initialize(driver::IDriver* pDriver) NN_NOEXCEPT;

    Result Start() NN_NOEXCEPT;
    void Cancel() NN_NOEXCEPT;
    void Wait() NN_NOEXCEPT;

private:
    const int ThreadStackSize = 4 * 1024;

    static void ReceiveThreadEntry(void* arg) NN_NOEXCEPT;
    static void SendThreadEntry(void* arg) NN_NOEXCEPT;

    void ReceiveThread() NN_NOEXCEPT;
    void SendThread() NN_NOEXCEPT;

    Result ProcessReceive() NN_NOEXCEPT;
    Result ProcessSend() NN_NOEXCEPT;

    Result CheckReceivedHeader(const PacketHeader& header) NN_NOEXCEPT;
    Result ReceiveAndDiscard(int32_t size) NN_NOEXCEPT;

    ReceivePacketFactory m_ReceivePacketFactory;

    nn::os::ThreadType m_ReceiveThread;
    nn::os::ThreadType m_SendThread;

    nn::os::Event m_CancelEvent;

    void* m_pReceiveThreadStack;
    void* m_pSendThreadStack;

    mux::Mux* m_pMux;
    driver::IDriver* m_pDriver;
    bool m_ThreadRunning;
};

}}}
