﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/htclow/detail/htclow_IUserServiceObject.h>

namespace nn {
namespace htclow {
namespace server {

class UserServiceObject
{
public:
    nn::Result Open(nn::htclow::detail::ChannelInternalType channel) NN_NOEXCEPT;
    nn::Result Close(nn::htclow::detail::ChannelInternalType channel) NN_NOEXCEPT;
    nn::Result Connect(nn::htclow::detail::ChannelInternalType channel) NN_NOEXCEPT;
    nn::Result Shutdown(nn::htclow::detail::ChannelInternalType channel) NN_NOEXCEPT;
    nn::Result Receive(nn::sf::Out<std::uint64_t> outSize, const nn::sf::OutBuffer& outBuffer, nn::htclow::detail::ChannelInternalType channel) NN_NOEXCEPT;
    nn::Result Send(nn::sf::Out<std::uint64_t> outSize, const nn::sf::InBuffer& buffer, nn::htclow::detail::ChannelInternalType channel) NN_NOEXCEPT;
    nn::Result GetClosedEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::htclow::detail::ChannelInternalType channel) NN_NOEXCEPT;
    nn::Result GetEstablishedEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::htclow::detail::ChannelInternalType channel) NN_NOEXCEPT;
    nn::Result GetReceiveReadyEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::htclow::detail::ChannelInternalType channel) NN_NOEXCEPT;
    nn::Result GetSendReadyEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::htclow::detail::ChannelInternalType channel) NN_NOEXCEPT;
    nn::Result GetSendCompleteEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::htclow::detail::ChannelInternalType channel) NN_NOEXCEPT;
    nn::Result GetHostConnectEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
    nn::Result GetHostDisconnectEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
};

}}}
