﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>

#include <nn/sf/sf_HipcServer.h>
#include <nn/sf/sf_ObjectFactory.h>

#include <nn/htclow/detail/htclow_DebugServiceName.h>
#include <nn/htclow/detail/htclow_UserServiceName.h>
#include <nn/htclow/server/htclow_Server.h>

#include "htclow_DebugServiceObject.h"
#include "htclow_Impl.h"
#include "htclow_UserServiceObject.h"

namespace nn { namespace htclow { namespace server {

namespace {
    const int MaxSessionCount = 8; // TORIEAZU
    const int MaxPortCount = 1;

    class ServerManager : public nn::sf::HipcSimpleAllInOneServerManager<MaxSessionCount, MaxPortCount>
    {
    };

    ServerManager g_UserServerManager;
    ServerManager g_DebugServerManager;

    nn::sf::UnmanagedServiceObject<nn::htclow::detail::IUserServiceObject, nn::htclow::server::UserServiceObject> g_UserServiceObject;
    nn::sf::UnmanagedServiceObject<nn::htclow::detail::IDebugServiceObject, nn::htclow::server::DebugServiceObject> g_DebugServiceObject;
}

void Initialize() NN_NOEXCEPT
{
    HtclowImpl::GetInstance();
}

nn::sf::SharedPointer<detail::IUserServiceObject> GetUserServiceObject() NN_NOEXCEPT
{
    return g_UserServiceObject.GetShared();
}

nn::sf::SharedPointer<detail::IDebugServiceObject> GetDebugServiceObject() NN_NOEXCEPT
{
    return g_DebugServiceObject.GetShared();
}

void RegisterUserHipcServer() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(g_UserServerManager.RegisterObjectForPort(g_UserServiceObject.GetShared(), MaxSessionCount, detail::UserServiceName));
}

void RegisterDebugHipcServer() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(g_DebugServerManager.RegisterObjectForPort(g_DebugServiceObject.GetShared(), MaxSessionCount, detail::DebugServiceName));
}

void StartUserHipcServer() NN_NOEXCEPT
{
    g_UserServerManager.Start();
}

void StartDebugHipcServer() NN_NOEXCEPT
{
    g_DebugServerManager.Start();
}

void LoopUserHipcServer() NN_NOEXCEPT
{
    g_UserServerManager.LoopAuto();
}

void LoopDebugHipcServer() NN_NOEXCEPT
{
    g_DebugServerManager.LoopAuto();
}

}}}
