﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstring>
#include <memory>

#include <nn/nn_Result.h>

#include "htclow_Allocator.h"
#include "htclow_Packet.h"

namespace nn { namespace htclow { namespace server {

class SendPacketFactory
{
    NN_DISALLOW_COPY(SendPacketFactory);
    NN_DISALLOW_MOVE(SendPacketFactory);

public:
    SendPacketFactory() NN_NOEXCEPT
        : m_Version(MaxVersion)
    {
    }

    int16_t GetVersion() NN_NOEXCEPT
    {
        return m_Version;
    }

    void SetVersion(int16_t version) NN_NOEXCEPT
    {
        m_Version = version;
    }

    std::unique_ptr<SendPacket> MakeSynPacket(detail::ChannelInternalType channel) NN_NOEXCEPT;

    std::unique_ptr<SendPacket> MakeDataPacket(detail::ChannelInternalType channel, const void* body, int bodySize) NN_NOEXCEPT;

    std::unique_ptr<SendPacket> MakeDataAckPacket(detail::ChannelInternalType channel, int64_t sequenceId) NN_NOEXCEPT;

    std::unique_ptr<SendPacket> MakeFinPacket(detail::ChannelInternalType channel) NN_NOEXCEPT;

    std::unique_ptr<SendPacket> MakeFinAckPacket(detail::ChannelInternalType channel, int64_t sequenceId) NN_NOEXCEPT;

private:
    void InitializeHeaderCommon(PacketHeader* pOutHeader) NN_NOEXCEPT;

    int16_t m_Version;
};

class ReceivePacketFactory
{
    NN_DISALLOW_COPY(ReceivePacketFactory);
    NN_DISALLOW_MOVE(ReceivePacketFactory);

public:
    ReceivePacketFactory() NN_NOEXCEPT
    {
    }

    std::unique_ptr<ReceivePacket> MakePacket(const PacketHeader* pHeader) NN_NOEXCEPT;
};


}}}
