﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/os.h>
#include <nn/os/os_SystemEvent.h>

#include "driver/htclow_IDriver.h"
#include "htclow_Worker.h"

namespace nn { namespace htclow { namespace server {

class Listener final
{
    NN_DISALLOW_COPY(Listener);
    NN_DISALLOW_MOVE(Listener);

public:
    explicit Listener(Worker* pWorker) NN_NOEXCEPT;
    ~Listener() NN_NOEXCEPT;

    Result Start(driver::IDriver* pDriver) NN_NOEXCEPT;
    void Cancel() NN_NOEXCEPT;
    void Wait() NN_NOEXCEPT;

    nn::os::SystemEvent* GetConnectEvent() NN_NOEXCEPT
    {
        return &m_ConnectEvent;
    }

    nn::os::SystemEvent* GetDisconnectEvent() NN_NOEXCEPT
    {
        return &m_DisconnectEvent;
    }

private:
    const int ThreadStackSize = 4 * 1024;

    static void ListenThreadEntry(void* pThis) NN_NOEXCEPT;
    void ListenThread() NN_NOEXCEPT;

    void SetEvent(bool connected) NN_NOEXCEPT;

    nn::os::SystemEvent m_ConnectEvent;
    nn::os::SystemEvent m_DisconnectEvent;

    nn::os::ThreadType m_ListenThread;

    void* m_pListenThreadStack;

    driver::IDriver* m_pDriver;
    Worker* m_pWorker;

    bool m_ThreadRunning;
    bool m_Cancelled;
};

}}}
