﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>

#include "htclow_Allocator.h"
#include "htclow_Impl.h"

namespace nn { namespace htclow { namespace server {

namespace {
    nn::os::SdkMutexType g_Mutex = NN_OS_SDK_MUTEX_INITIALIZER();
    HtclowImpl* g_pImpl = nullptr;
}

HtclowImpl* HtclowImpl::GetInstance() NN_NOEXCEPT
{
    // Double checking lock
    if (g_pImpl != nullptr)
    {
        return g_pImpl;
    }

    std::lock_guard<decltype(g_Mutex)> lock(g_Mutex);

    if (g_pImpl != nullptr)
    {
        return g_pImpl;
    }

    // Initialize
    InitializeAllocator();

    static HtclowImpl s_Impl;
    g_pImpl = &s_Impl;

    return g_pImpl;
}

}}}
