﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>

namespace nn { namespace htclow { namespace server { namespace driver {

/*
 * @brief   htclow ドライバを抽象化するインターフェース
 * @detail  TCP, USB などの htclow ドライバを抽象化するインターフェース
 */
class IDriver
{
public:
    /*
     * @brief htclow ドライバの使用を開始する (動作中の通信路切替を含む) 際に呼ぶ関数
     */
    virtual Result Open() NN_NOEXCEPT = 0;

    /*
     * @brief htclow ドライバの使用を終了する (動作中の通信路切替を含む) 際に呼ぶ関数
     */
    virtual void Close() NN_NOEXCEPT = 0;

    /*
     * @brief ホストと接続する
     */
    virtual Result Connect() NN_NOEXCEPT = 0;

    /*
     * @brief ホストから切断する
     */
    virtual void Shutdown() NN_NOEXCEPT = 0;

    /*
     * @brief htclow ドライバにデータを送信する
     */
    virtual Result Send(const void* pBuffer, int bufferSize) NN_NOEXCEPT = 0;

    /*
     * @brief htclow ドライバからデータを受信する
     */
    virtual Result Receive(void* pOutBuffer, int bufferSize) NN_NOEXCEPT = 0;

    /*
     * @brief Send や Receive をキャンセルさせる
     */
    virtual void Cancel() NN_NOEXCEPT = 0;
};

}}}}
