﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>

#include <nn/sf/sf_HipcServer.h>
#include <nn/sf/sf_ObjectFactory.h>

#include <nn/htcfs/detail/htcfs_IServiceObject.h>
#include <nn/htcfs/detail/htcfs_ServiceName.h>

#include "htcfs_FileSystemServiceObject.h"
#include "htcfs_Impl.h"

namespace nn { namespace htcfs { namespace server {

namespace {
    const int MaxSessionCount = 30; // TORIEAZU
    const int MaxPortCount = 1;

    class ServerManager : public nn::sf::HipcSimpleAllInOneServerManager<MaxSessionCount, MaxPortCount>
    {
    };

    ServerManager g_ServerManager;

    nn::sf::UnmanagedServiceObject<nn::htcfs::IFileSystem, nn::htcfs::server::FileSystemServiceObject> g_FileSystemServiceObject;
}

void Initialize() NN_NOEXCEPT
{
    HtcfsImpl::GetInstance();
}

nn::sf::SharedPointer<IFileSystem> GetServiceObject() NN_NOEXCEPT
{
    return g_FileSystemServiceObject.GetShared();
}

void RegisterHipcServer() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(g_ServerManager.RegisterObjectForPort(g_FileSystemServiceObject.GetShared(), MaxSessionCount, detail::ServiceName));
}

void StartHipcServer() NN_NOEXCEPT
{
    g_ServerManager.Start();
}

void LoopHipcServer() NN_NOEXCEPT
{
    g_ServerManager.LoopAuto();
}

}}}
