﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/result/result_HandlingUtility.h>
#include <nn/sf/sf_ExpHeapAllocator.h>
#include <nn/sf/sf_ObjectFactory.h>

#include "htcfs_DirectoryServiceObject.h"
#include "htcfs_Impl.h"

namespace nn { namespace htcfs { namespace server {

DirectoryServiceObject::DirectoryServiceObject(int32_t handle) NN_NOEXCEPT
    : m_Handle(handle)
{
}

DirectoryServiceObject::~DirectoryServiceObject() NN_NOEXCEPT
{
    HtcfsImpl::GetInstance()->CloseDirectory(m_Handle);
}

nn::Result DirectoryServiceObject::GetPriorityForDirectory(nn::sf::Out<std::int32_t> outPriority) NN_NOEXCEPT
{
    int32_t priority;
    NN_RESULT_DO(HtcfsImpl::GetInstance()->GetPriorityForDirectory(&priority, m_Handle));
    *outPriority = priority;
    NN_RESULT_SUCCESS;
}

nn::Result DirectoryServiceObject::SetPriorityForDirectory(std::int32_t priority) NN_NOEXCEPT
{
    return HtcfsImpl::GetInstance()->SetPriorityForDirectory(priority, m_Handle);
}

nn::Result DirectoryServiceObject::ReadDirectory(nn::sf::Out<std::int64_t> outCount, const nn::sf::OutArray<nn::fs::DirectoryEntry>& entries) NN_NOEXCEPT
{
    int64_t count;
    NN_RESULT_DO(HtcfsImpl::GetInstance()->ReadDirectory(&count, entries.GetData(), entries.GetLength(), m_Handle));
    *outCount = count;
    NN_RESULT_SUCCESS;
}

nn::Result DirectoryServiceObject::GetEntryCount(nn::sf::Out<std::int64_t> outCount) NN_NOEXCEPT
{
    int64_t count;
    NN_RESULT_DO(HtcfsImpl::GetInstance()->GetEntryCount(&count, m_Handle));
    *outCount = count;
    NN_RESULT_SUCCESS;
}

}}}
