﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_DeviceCode.h>
#include <nn/devicecode/devicecode_Predefined.gpio.h>

namespace nn {
namespace gpio {
namespace driver {

// TORIAEZU: GpioPadName の定義値がインデックスとなって対応
const nn::DeviceCode Gen1PadNameConvertTable[] =
{
    nn::DeviceCode::GetInvalidCode(),   // 0
    NN_DEVICECODE_GPIO_TEGRA_PAD(Z,4),  // GpioPadName_CodecLdoEnTemp     = 1
    NN_DEVICECODE_GPIO_TEGRA_PAD(E,4),  // GpioPadName_PowSdEn            = 2
    NN_DEVICECODE_GPIO_TEGRA_PAD(H,4),  // GpioPadName_BtRst              = 3
    NN_DEVICECODE_GPIO_TEGRA_PAD(BB,2), // GpioPadName_RamCode3           = 4
    NN_DEVICECODE_GPIO_TEGRA_PAD(BB,3), // GpioPadName_GameCardReset      = 5
    NN_DEVICECODE_GPIO_TEGRA_PAD(BB,4), // GpioPadName_CodecAlert         = 6
    NN_DEVICECODE_GPIO_TEGRA_PAD(E,5),  // GpioPadName_PowGc              = 7
    NN_DEVICECODE_GPIO_TEGRA_PAD(S,0),  // GpioPadName_DebugDriverDet = 8
    NN_DEVICECODE_GPIO_TEGRA_PAD(S,1),  // GpioPadName_BattChgStatus      = 9
    NN_DEVICECODE_GPIO_TEGRA_PAD(S,6),  // GpioPadName_BattChgEnableN     = 10
    NN_DEVICECODE_GPIO_TEGRA_PAD(S,7),  // GpioPadName_FanTach            = 11
    NN_DEVICECODE_GPIO_TEGRA_PAD(E,6),  // GpioPadName_ExtconDetS         = 12
    NN_DEVICECODE_GPIO_TEGRA_PAD(A,5),  // GpioPadName_Vdd50AEn           = 13
    NN_DEVICECODE_GPIO_TEGRA_PAD(P,0),  // GpioPadName_SdevCoaxSel1       = 14
    NN_DEVICECODE_GPIO_TEGRA_PAD(S,3),  // GpioPadName_GameCardCd         = 15
    NN_DEVICECODE_GPIO_TEGRA_PAD(P,5),  // GpioPadName_ProdType0          = 16
    NN_DEVICECODE_GPIO_TEGRA_PAD(P,4),  // GpioPadName_ProdType1          = 17
    NN_DEVICECODE_GPIO_TEGRA_PAD(P,3),  // GpioPadName_ProdType2          = 18
    NN_DEVICECODE_GPIO_TEGRA_PAD(P,2),  // GpioPadName_ProdType3          = 19
    NN_DEVICECODE_GPIO_TEGRA_PAD(X,4),  // GpioPadName_TempAlert          = 20
    NN_DEVICECODE_GPIO_TEGRA_PAD(V,6),  // GpioPadName_CodecHpDetIrq      = 21
    NN_DEVICECODE_GPIO_TEGRA_PAD(X,2),  // GpioPadName_MotionInt          = 22
    NN_DEVICECODE_GPIO_TEGRA_PAD(X,1),  // GpioPadName_TpIrq              = 23
    NN_DEVICECODE_GPIO_TEGRA_PAD(X,5),  // GpioPadName_ButtonSleep2       = 24
    NN_DEVICECODE_GPIO_TEGRA_PAD(X,6),  // GpioPadName_ButtonVolUp        = 25
    NN_DEVICECODE_GPIO_TEGRA_PAD(X,7),  // GpioPadName_ButtonVolDn        = 26
    NN_DEVICECODE_GPIO_TEGRA_PAD(Y,0),  // GpioPadName_BattMgicIrq        = 27
    NN_DEVICECODE_GPIO_TEGRA_PAD(Y,1),  // GpioPadName_RecoveryKey        = 28
    NN_DEVICECODE_GPIO_TEGRA_PAD(V,1),  // GpioPadName_PowLcdBlEn         = 29
    NN_DEVICECODE_GPIO_TEGRA_PAD(V,2),  // GpioPadName_LcdReset           = 30
    NN_DEVICECODE_GPIO_TEGRA_PAD(K,5),  // GpioPadName_PdVconnEn          = 31
    NN_DEVICECODE_GPIO_TEGRA_PAD(V,5),  // GpioPadName_PdRstN             = 32
    NN_DEVICECODE_GPIO_TEGRA_PAD(Z,0),  // GpioPadName_Bq24190Irq         = 33
    NN_DEVICECODE_GPIO_TEGRA_PAD(Z,2),  // GpioPadName_SdevCoaxSel0       = 34
    NN_DEVICECODE_GPIO_TEGRA_PAD(Z,3),  // GpioPadName_SdWp               = 35
    NN_DEVICECODE_GPIO_TEGRA_PAD(J,7),  // GpioPadName_TpReset            = 36
    NN_DEVICECODE_GPIO_TEGRA_PAD(K,0),  // GpioPadName_BtGpio2            = 37
    NN_DEVICECODE_GPIO_TEGRA_PAD(K,1),  // GpioPadName_BtGpio3            = 38
    NN_DEVICECODE_GPIO_TEGRA_PAD(K,2),  // GpioPadName_BtGpio4            = 39
    NN_DEVICECODE_GPIO_TEGRA_PAD(K,4),  // GpioPadName_CradleIrq          = 40
    NN_DEVICECODE_GPIO_TEGRA_PAD(K,6),  // GpioPadName_PowVcpuInt         = 41
    NN_DEVICECODE_GPIO_TEGRA_PAD(K,7),  // GpioPadName_Max77621GpuInt     = 42
    NN_DEVICECODE_GPIO_TEGRA_PAD(K,3),  // GpioPadName_ExtconChgU         = 43
    NN_DEVICECODE_GPIO_TEGRA_PAD(CC,3), // GpioPadName_ExtconChgS         = 44
    NN_DEVICECODE_GPIO_TEGRA_PAD(H,0),  // GpioPadName_WifiRfDisable      = 45
    NN_DEVICECODE_GPIO_TEGRA_PAD(H,1),  // GpioPadName_WifiReset          = 46
    NN_DEVICECODE_GPIO_TEGRA_PAD(H,3),  // GpioPadName_ApWakeBt           = 47
    NN_DEVICECODE_GPIO_TEGRA_PAD(H,5),  // GpioPadName_BtWakeAp           = 48
    NN_DEVICECODE_GPIO_TEGRA_PAD(H,7),  // GpioPadName_BtGpio5            = 49
    NN_DEVICECODE_GPIO_TEGRA_PAD(I,0),  // GpioPadName_PowLcdVddPEn       = 50
    NN_DEVICECODE_GPIO_TEGRA_PAD(I,1),  // GpioPadName_PowLcdVddNEn       = 51
    NN_DEVICECODE_GPIO_TEGRA_PAD(H,6),  // GpioPadName_ExtconDetU         = 52
    NN_DEVICECODE_GPIO_TEGRA_PAD(CC,2), // GpioPadName_RamCode2           = 53
    NN_DEVICECODE_GPIO_TEGRA_PAD(CC,4), // GpioPadName_Vdd50BEn           = 54
    NN_DEVICECODE_GPIO_TEGRA_PAD(H,2),  // GpioPadName_WifiWakeHost       = 55
    NN_DEVICECODE_GPIO_TEGRA_PAD(Z,1),  // GpioPadName_SdCd               = 56
    NN_DEVICECODE_GPIO_TEGRA_PAD(J,5),  // GpioPadName_OtgFet1ForSdev     = 57
    NN_DEVICECODE_GPIO_TEGRA_PAD(L,0),  // GpioPadName_OtgFet2ForSdev     = 58
    NN_DEVICECODE_GPIO_TEGRA_PAD(H,6),  // GpioPadName_ExtConWakeU        = 59
    NN_DEVICECODE_GPIO_TEGRA_PAD(E,6),  // GpioPadName_ExtConWakeS        = 60
    NN_DEVICECODE_GPIO_NX_PMU_IRQ,      // GpioPadName_PmuIrq             = 61
    NN_DEVICECODE_GPIO_TEGRA_PAD(G,3),  // GpioPadName_ExtUart2Cts        = 62
    NN_DEVICECODE_GPIO_TEGRA_PAD(D,4),  // GpioPadName_ExtUart3Cts        = 63
    NN_DEVICECODE_GPIO_TEGRA_PAD(BB,1), // GpioPadName_5VStepDownEn       = 64
    NN_DEVICECODE_GPIO_TEGRA_PAD(B,4),  // GpioPadName_UsbSwitchB2Oc      = 65
    NN_DEVICECODE_GPIO_TEGRA_PAD(B,5),  // GpioPadName_5VStepDownPg       = 66
    NN_DEVICECODE_GPIO_TEGRA_PAD(E,1),  // GpioPadName_UsbSwitchAEn       = 67
    NN_DEVICECODE_GPIO_TEGRA_PAD(E,7),  // GpioPadName_UsbSwitchAFlag     = 68
    NN_DEVICECODE_GPIO_TEGRA_PAD(S,2),  // GpioPadName_UsbSwitchB3Oc      = 69
    NN_DEVICECODE_GPIO_TEGRA_PAD(S,5),  // GpioPadName_UsbSwitchB3En      = 70
    NN_DEVICECODE_GPIO_TEGRA_PAD(T,0),  // GpioPadName_UsbSwitchB2En      = 71
    NN_DEVICECODE_GPIO_TEGRA_PAD(C,0),  // GpioPadName_Hdmi5VEn           = 72
    NN_DEVICECODE_GPIO_TEGRA_PAD(C,1),  // GpioPadName_UsbSwitchB1En      = 73
    NN_DEVICECODE_GPIO_TEGRA_PAD(C,2),  // GpioPadName_HdmiPdTrEn         = 74
    NN_DEVICECODE_GPIO_TEGRA_PAD(I,2),  // GpioPadName_FanEn              = 75
    NN_DEVICECODE_GPIO_TEGRA_PAD(CC,6), // GpioPadName_UsbSwitchB1Oc      = 76
    NN_DEVICECODE_GPIO_TEGRA_PAD(V,4),  // GpioPadName_PwmFan             = 77
    NN_DEVICECODE_GPIO_TEGRA_PAD(CC,1), // GpioPadName_HdmiHpd            = 78
    NN_DEVICECODE_GPIO_TEGRA_PAD(K,6),  // GpioPadName_Max77812Irq        = 79
    NN_DEVICECODE_GPIO_TEGRA_PAD(E,0),  // GpioPadName_Debug0             = 80
    NN_DEVICECODE_GPIO_TEGRA_PAD(E,1),  // GpioPadName_Debug1             = 81
    NN_DEVICECODE_GPIO_TEGRA_PAD(E,2),  // GpioPadName_Debug2             = 82
    NN_DEVICECODE_GPIO_TEGRA_PAD(E,3),  // GpioPadName_Debug3             = 83
    NN_DEVICECODE_GPIO_TEGRA_PAD(J,4),  // GpioPadName_NfcIrq             = 84
    NN_DEVICECODE_GPIO_TEGRA_PAD(K,7),  // GpioPadName_NfcReset           = 85
    NN_DEVICECODE_GPIO_TEGRA_PAD(S,4),  // GpioPadName_McuInt             = 86
    NN_DEVICECODE_GPIO_TEGRA_PAD(T,0),  // GpioPadName_McuBoot            = 87
    NN_DEVICECODE_GPIO_TEGRA_PAD(T,1),  // GpioPadName_McuReset           = 88
    NN_DEVICECODE_GPIO_TEGRA_PAD(X,3),  // GpioPadName_Vdd5V3En           = 89
    NN_DEVICECODE_GPIO_TEGRA_PAD(CC,5), // GpioPadName_McuPor             = 90
};

const int Gen1PadNameConvertTableLength = NN_ARRAY_SIZE(Gen1PadNameConvertTable);

} // driver
} // gpio
} // nn
