﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>

#include <nn/dd.h>

#include <nn/gpio/gpio_PadMap.h>
#include <nn/gpio/driver/gpio_PadAccessor.h>

#include "gpio_RegAccessor-soc.tegra.h"
#include "gpio_DdUtil.h"


namespace nn{
namespace gpio{
namespace driver{
namespace detail{

class PinmuxRegAccessor
{

public:
    PinmuxRegAccessor() NN_NOEXCEPT :
    m_ApbMiscVirtualAddress(0)
    {
        // APB_MISC
        const nn::dd::PhysicalAddress   ApbMiscPhysicalAddress   = 0x070000000ull;
        const size_t                    ApbMiscAddressSize       = 0x4000;

        m_ApbMiscVirtualAddress = nn::dd::QueryIoMappingAddress(ApbMiscPhysicalAddress, ApbMiscAddressSize);
        if (m_ApbMiscVirtualAddress == 0)
        {
            // physicalAddress が指す I/O アドレスがマッピングされていない
            NN_ABORT("I/O registers for 0x%llx are not mapped. Make sure the capability setting is properly set for this process.\n", ApbMiscPhysicalAddress);
        }
    }

    // GPIO ライブラリで使用するために Pinmux を設定する関数
    void SetGpioPinmux(InternalGpioPadNumber pad, Direction direction) NN_NOEXCEPT;

private:
    uintptr_t m_ApbMiscVirtualAddress;
};

} // detail
} // driver
} // gpio
} // nn
