﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn {
namespace gpio {
namespace driver {
namespace detail {

static struct WakePinConfig initWakePinConfigListForIcosa[] =
{
    { nne::wec::WakeEvent_PEX_WAKE_N, false, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_GPIO_PA6, false, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_QSPI_CS_N, false, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_SPI2_MOSI, false, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_GPIO_PE6, true, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_GPIO_PE7, false, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_UART2_CTS, true, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_UART3_CTS, true, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_WIFI_WAKE_AP, true, nne::wec::WakeEventLevel_High },
    { nne::wec::WakeEvent_GPIO_PH6, true, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_NFC_INT, false, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_GEN1_I2C_SDA, false, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_GEN2_I2C_SDA, false, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_GPIO_PK4, true, nne::wec::WakeEventLevel_Low },
    { nne::wec::WakeEvent_GPIO_PK6, false, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_SDMMC1_DAT1, false, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_SDMMC2_DAT1, false, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_HDMI_CEC, false, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_GEN3_I2C_SDA, false, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_GPIO_PL1, false, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_CLK_32K_OUT, false, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_PWR_I2C_SDA, false, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_BUTTON_POWER_ON, false, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_BUTTON_VOL_UP, false, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_BUTTON_VOL_DOWN, false, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_BUTTON_SLIDE_SW, true, nne::wec::WakeEventLevel_Low },
    { nne::wec::WakeEvent_BUTTON_HOME, false, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_TEMP_ALERT, false, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_GPIO_PZ0, true, nne::wec::WakeEventLevel_Low },
    { nne::wec::WakeEvent_GPIO_PZ1, true, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_GPIO_PZ2, false, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_SDMMC3_DAT1, false, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_SDMMC4_DAT1, false, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_CAM_I2C_SCL, false, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_CAM_I2C_SDA, true, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_GPIO_PZ5, false, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_DP_HPD0, false, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_PWR_INT_N, true, nne::wec::WakeEventLevel_Low },
    { nne::wec::WakeEvent_BT_WAKE_AP, true, nne::wec::WakeEventLevel_Low },
    { nne::wec::WakeEvent_HDMI_INT_DP_HPD, false, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_USB_VBUS_EN0, false, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_USB_VBUS_EN1, false, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_LCD_RST, false, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_LCD_GPIO1, false, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_LCD_GPIO2, false, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_UART4_CTS, false, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_MODEM_WAKE_AP, false, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_TOUCH_INT, false, nne::wec::WakeEventLevel_Auto },
    { nne::wec::WakeEvent_MOTION_INT, false, nne::wec::WakeEventLevel_Auto },
};



} // detail
} // driver
} // gpio
} // nn
