﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn {
namespace gpio {
namespace driver {
namespace detail {


static struct GpioInitialConfig initGpioConfigListForIcosa[] =
{
    {
        nn::gpio::GpioPadName_RamCode3,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        nn::gpio::GpioPadName_GameCardReset,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_CodecAlert,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_PowSdEn,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_PowGc,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_ExtConWakeS,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_GameCardCd,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        nn::gpio::GpioPadName_DebugControllerDet,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_BattChgStatus,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_BattChgEnableN,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_FanTach,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        nn::gpio::GpioPadName_Vdd50AEn,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_SdevCoaxSel1,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_ProdType0,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_ProdType1,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_ProdType2,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_ProdType3,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_TempAlert,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        nn::gpio::GpioPadName_MotionInt,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_CodecHpDetIrq,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_TpIrq,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        nn::gpio::GpioPadName_ButtonSleep2,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        nn::gpio::GpioPadName_ButtonVolUp,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        nn::gpio::GpioPadName_ButtonVolDn,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        nn::gpio::GpioPadName_BattMgicIrq,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        nn::gpio::GpioPadName_RecoveryKey,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_PowLcdBlEn,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_LcdReset,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_PdRstN,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_Bq24190Irq,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        nn::gpio::GpioPadName_SdCd,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        nn::gpio::GpioPadName_SdevCoaxSel0,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_SdWp,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        nn::gpio::GpioPadName_CodecLdoEnTemp,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_OtgFet1ForSdev,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_TpReset,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_ExtconDetU,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_BtGpio2,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_BtGpio3,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_BtGpio4,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_ExtconChgU,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_CradleIrq,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        nn::gpio::GpioPadName_PdVconnEn,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_PowVcpuInt,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        nn::gpio::GpioPadName_Max77621GpuInt,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        nn::gpio::GpioPadName_OtgFet2ForSdev,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_ExtconDetS,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_WifiRfDisable,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_WifiReset,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_WifiWakeHost,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_ApWakeBt,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_BtRst,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_BtWakeAp,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_ExtConWakeU,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_BtGpio5,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_PowLcdVddPEn,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_PowLcdVddNEn,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_RamCode2,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        nn::gpio::GpioPadName_ExtconChgS,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_Vdd50BEn,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
};


} // detail
} // driver
} // gpio
} // nn
