﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/account/account_Result.h>
#include <nn/fs/fs_Utility.h>
#include <nn/fs/detail/fs_ResultHandlingUtility.h>

namespace nn { namespace fs {

    nn::fs::UserId ConvertAccountUidToFsUserId(const nn::account::Uid& uid) NN_NOEXCEPT
    {
        nn::fs::UserId userId;
        userId._data[0] = uid._data[0];
        userId._data[1] = uid._data[1];
        return userId;
    }

    void CheckUid(const nn::account::Uid& user) NN_NOEXCEPT
    {
        bool isUserExist = false;
        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::account::GetUserExistence(&isUserExist, user));
        NN_FS_ABORT_UNLESS_WITH_RESULT(isUserExist, nn::account::ResultUserNotExist(), "User id is invalid.\n");
    }

    void AssertCheckUid(const nn::account::Uid& user) NN_NOEXCEPT
    {
        NN_UNUSED(user);
        NN_SDK_ASSERT((CheckUid(user), true));
    }

}}
