﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

namespace nn.account
{
    [CppRefPath(@"<nn/account/account_Types.h>")]
    [ExternalStruct(16, 8)]
    public struct Uid
    {
    }

    [CppRefPath(@"<nn/account/account_Types.h>")]
    [ExternalStruct(8, 8)]
    public struct NetworkServiceAccountId
    {
    }

    [CppRefPath(@"<nn/account/account_Types.h>")]
    [ExternalStruct(33, 1)]
    public struct Nickname
    {
    }
}

namespace nn.settings
{
    [CppRefPath(@"<nn/settings/settings_Language.h>")]
    [ExternalStruct(8, 1)]
    public struct LanguageCode
    {
    }
}

namespace nn.friends
{
    [CppRefPath(@"<nn/friends/friends_Types.h>")]
    [ExternalStruct(72, 1)]
    [LargeData]
    public struct InAppScreenName
    {
    }

    [CppRefPath(@"<nn/friends/friends_Types.h>")]
    [ExternalStruct(160, 1)]
    public struct Url
    {
    }

    [CppRefPath(@"<nn/friends/friends_Types.h>")]
    [ExternalStruct(16, 8)]
    public struct ApplicationInfo
    {
    }

    [CppRefPath(@"<nn/friends/friends_Types.h>")]
    [ExternalStruct(64, 1)]
    [LargeData]
    public struct PlayHistoryRegistrationKey
    {
    }

    [CppRefPath(@"<nn/friends/friends_TypesFriendRequest.h>")]
    [ExternalStruct(64, 1)]
    public struct FacedFriendRequestRegistrationKey
    {
    }

    [CppRefPath(@"<nn/friends/friends_TypesAdmin.h>")]
    [ExternalStruct(8, 8)]
    public struct RequestId
    {
    }

    [CppRefPath(@"<nn/friends/friends_TypesAdmin.h>")]
    [ExternalStruct(8, 8)]
    public struct Relationship
    {
    }

    [CppRefPath(@"<nn/friends/friends_TypesAdmin.h>")]
    [ExternalStruct(16, 8)]
    public struct PlayHistoryStatistics
    {
    }

    [CppRefPath(@"<nn/friends/friends_TypesAdmin.h>")]
    [ExternalStruct(32, 1)]
    public struct FriendCode
    {
    }

    [CppRefPath(@"<nn/friends/friends_TypesAdmin.h>")]
    [ExternalStruct(16, 8)]
    public struct ExternalApplicationCatalogId
    {
    }

    [CppRefPath(@"<nn/friends/friends_TypesAdmin.h>")]
    [ExternalStruct(1208, 8)]
    [LargeData]
    public struct ExternalApplicationCatalog
    {
    }

    [CppRefPath(@"<nn/friends/friends_TypesAdmin.h>")]
    [ExternalStruct(32, 1)]
    public struct MiiName
    {
    }

    [CppRefPath(@"<nn/friends/friends_TypesAdmin.h>")]
    [ExternalStruct(16, 1)]
    public struct MiiImageUrlParam
    {
    }

    [CppRefPath(@"<nn/friends/friends_TypesAdmin.h>")]
    [ExternalStruct(56, 8)]
    [LargeData]
    public struct NintendoNetworkIdUserInfo
    {
    }

    [CppRefPath(@"<nn/friends/friends_TypesAdmin.h>")]
    [ExternalStruct(8, 1)]
    public struct SnsAccountLinkage
    {
    }

    [CppRefPath(@"<nn/friends/friends_TypesAdmin.h>")]
    [ExternalStruct(896, 1)]
    [LargeData]
    public struct SnsAccountProfile
    {
    }

    [CppRefPath(@"<nn/friends/friends_TypesAdmin.h>")]
    [ExternalStruct(4096, 1)]
    [LargeData]
    public struct WebPageUrl
    {
    }
}

namespace nn.friends.detail
{
    [CppRefPath(@"<nn/friends/detail/friends_ImplFriend.h>")]
    [ExternalStruct(512, 8)]
    [LargeData]
    public struct FriendImpl
    {
    }

    [CppRefPath(@"<nn/friends/detail/friends_ImplFriendDetailedInfo.h>")]
    [ExternalStruct(2048, 8)]
    [LargeData]
    public struct FriendDetailedInfoImpl
    {
    }

    [CppRefPath(@"<nn/friends/detail/friends_ImplFriendRequest.h>")]
    [ExternalStruct(512, 8)]
    [LargeData]
    public struct FriendRequestImpl
    {
    }

    [CppRefPath(@"<nn/friends/detail/friends_ImplFriendCandidate.h>")]
    [ExternalStruct(256, 8)]
    [LargeData]
    public struct FriendCandidateImpl
    {
    }

    [CppRefPath(@"<nn/friends/detail/friends_ImplNintendoNetworkIdFriend.h>")]
    [ExternalStruct(256, 8)]
    [LargeData]
    public struct NintendoNetworkIdFriendImpl
    {
    }

    [CppRefPath(@"<nn/friends/detail/friends_ImplBlockedUser.h>")]
    [ExternalStruct(512, 8)]
    [LargeData]
    public struct BlockedUserImpl
    {
    }

    [CppRefPath(@"<nn/friends/detail/friends_ImplProfile.h>")]
    [ExternalStruct(256, 8)]
    [LargeData]
    public struct ProfileImpl
    {
    }

    [CppRefPath(@"<nn/friends/detail/friends_ImplProfileExtra.h>")]
    [ExternalStruct(1024, 8)]
    [LargeData]
    public struct ProfileExtraImpl
    {
    }

    [CppRefPath(@"<nn/friends/detail/friends_ImplPresence.h>")]
    [ExternalStruct(224, 8)]
    [LargeData]
    public struct UserPresenceImpl
    {
    }

    [CppRefPath(@"<nn/friends/detail/friends_ImplPresenceView.h>")]
    [ExternalStruct(224, 8)]
    [LargeData]
    public struct UserPresenceViewImpl
    {
    }

    [CppRefPath(@"<nn/friends/detail/friends_ImplPlayHistory.h>")]
    [ExternalStruct(256, 8)]
    [LargeData]
    public struct PlayHistoryImpl
    {
    }

    [CppRefPath(@"<nn/friends/detail/friends_ImplSetting.h>")]
    [ExternalStruct(2048, 8)]
    [LargeData]
    public struct UserSettingImpl
    {
    }

    [CppRefPath(@"<nn/friends/detail/friends_ImplSetting.h>")]
    [ExternalStruct(64, 8)]
    [LargeData]
    public struct FriendSettingImpl
    {
    }

    [CppRefPath(@"<nn/friends/detail/friends_ImplSnsAccountFriend.h>")]
    [ExternalStruct(1024, 8)]
    [LargeData]
    public struct SnsAccountFriendImpl
    {
    }
}

namespace nn.friends.detail.ipc
{
    [CppRefPath(@"<nn/friends/detail/ipc/friends_IpcSizedStructure.h>")]
    [ExternalStruct(16, 8)]
    public struct SizedFriendFilter
    {
    }

    [CppRefPath(@"<nn/friends/detail/ipc/friends_IpcSizedStructure.h>")]
    [ExternalStruct(16, 8)]
    public struct SizedNotificationInfo
    {
    }
}

namespace nn.friends.detail.ipc
{
    [CppRefPath(@"<nn/friends/detail/ipc/friends_IFriendService.sfdl.h>")]
    public partial interface IFriendService : IServiceObject {}

    ////////////////////////////////////////////////////////////////////////////////
    // AsyncCallable API
    ////////////////////////////////////////////////////////////////////////////////
    public partial interface IFriendService : IServiceObject
    {
        [MethodId(0)]
        Result GetCompletionEvent(Out<NativeHandle> outHandle);

        [MethodId(1)]
        Result Cancel();
    }

    ////////////////////////////////////////////////////////////////////////////////
    // Generic API
    ////////////////////////////////////////////////////////////////////////////////
    public partial interface IFriendService : IServiceObject
    {
        [MethodId(10100)]
        Result GetFriendListIds(Out<int32_t> outCount, OutArray<nn.account.NetworkServiceAccountId> outAccountIds,
            nn.account.Uid uid, int32_t offset, SizedFriendFilter filter, [ProcessId] Bit64 processId);

        [MethodId(10101)]
        Result GetFriendList(Out<int32_t> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<FriendImpl> outFriends,
            nn.account.Uid uid, int32_t offset, SizedFriendFilter filter, [ProcessId] Bit64 processId);

        [MethodId(10102)]
        Result UpdateFriendInfo([BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<FriendImpl> outFriends,
            nn.account.Uid uid, InArray<nn.account.NetworkServiceAccountId> accountIds, [ProcessId] Bit64 processId);

        [MethodId(10110)]
        Result GetFriendProfileImage(Out<int32_t> outSize,
            nn.account.Uid uid, nn.account.NetworkServiceAccountId accountId, [BufferTransferMode(BufferTransferMode.MapAlias)] OutBuffer buffer);

        // ver.2.0.0
        // AsyncCall
        [MethodId(10200)]
        Result SendFriendRequestForApplication(nn.account.Uid uid, nn.account.NetworkServiceAccountId accountId,
            InAppScreenName inAppScreenName, InAppScreenName myInAppScreenName, [ProcessId] Bit64 processId);

        // [MethodId(30210)]
        // Result GetFacedFriendRequestRegistrationKey(Out<FacedFriendRequestRegistrationKey> outKey,
        //     nn.account.Uid uid);

        // ver.2.0.0
        [MethodId(10211)]
        Result AddFacedFriendRequestForApplication(nn.account.Uid uid, FacedFriendRequestRegistrationKey key,
            nn.account.Nickname nickname, [BufferTransferMode(BufferTransferMode.MapAlias)] InBuffer image,
            InAppScreenName inAppScreenName, InAppScreenName myInAppScreenName, [ProcessId] Bit64 processId);

        [MethodId(10400)]
        Result GetBlockedUserListIds(Out<int32_t> outCount, OutArray<nn.account.NetworkServiceAccountId> outAccountIds,
            nn.account.Uid uid, int32_t offset);

        // AsyncCall
        [MethodId(10500)]
        Result GetProfileList([BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<ProfileImpl> outProfiles,
            nn.account.Uid uid, InArray<nn.account.NetworkServiceAccountId> accountIds);

        [MethodId(10600)]
        Result DeclareOpenOnlinePlaySession(nn.account.Uid uid);

        [MethodId(10601)]
        Result DeclareCloseOnlinePlaySession(nn.account.Uid uid);

        [MethodId(10610)]
        Result UpdateUserPresence(nn.account.Uid uid, UserPresenceImpl presence, [ProcessId] Bit64 processId);

        [MethodId(10700)]
        Result GetPlayHistoryRegistrationKey(Out<PlayHistoryRegistrationKey> outKey,
            nn.account.Uid uid, bool isLocalPlay);

        [MethodId(10701)]
        Result GetPlayHistoryRegistrationKeyWithNetworkServiceAccountId(Out<PlayHistoryRegistrationKey> outKey,
            nn.account.NetworkServiceAccountId accountId, bool isLocalPlay);

        [MethodId(10702)]
        Result AddPlayHistory(nn.account.Uid uid, PlayHistoryRegistrationKey key,
            InAppScreenName inAppScreenName, InAppScreenName myInAppScreenName, [ProcessId] Bit64 processId);

        [MethodId(11000)]
        Result GetProfileImageUrl(Out<Url> outUrl, Url url, int32_t imageSize);
    }

    ////////////////////////////////////////////////////////////////////////////////
    // Viewer API
    ////////////////////////////////////////////////////////////////////////////////
    public partial interface IFriendService : IServiceObject
    {
        [MethodId(20100)]
        Result GetFriendCount(Out<int32_t> outCount,
            nn.account.Uid uid, SizedFriendFilter filter, [ProcessId] Bit64 processId);

        [MethodId(20101)]
        Result GetNewlyFriendCount(Out<int32_t> outCount,
            nn.account.Uid uid);

        [MethodId(20102)]
        Result GetFriendDetailedInfo(Out<FriendDetailedInfoImpl> outInfo,
            nn.account.Uid uid, nn.account.NetworkServiceAccountId accountId);

        // AsyncCall
        [MethodId(20103)]
        Result SyncFriendList(nn.account.Uid uid);

        [MethodId(20104)]
        Result RequestSyncFriendList(nn.account.Uid uid);

        [MethodId(20110)]
        Result LoadFriendSetting(Out<FriendSettingImpl> outSetting,
            nn.account.Uid uid, nn.account.NetworkServiceAccountId accountId);

        [MethodId(20200)]
        Result GetReceivedFriendRequestCount(Out<int32_t> outUnreadCount, Out<int32_t> outReadCount,
            nn.account.Uid uid);

        // AsyncCall
        [MethodId(20201)]
        Result GetFriendRequestList(Out<int32_t> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<FriendRequestImpl> outRequests,
            nn.account.Uid uid, int32_t offset, int32_t listType);

        // ver.2.0.0
        // AsyncCall
        [MethodId(20300)]
        Result GetFriendCandidateList(Out<int32_t> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<FriendCandidateImpl> outCandidates,
            nn.account.Uid uid, int32_t type);

        // ver.3.0.0
        // AsyncCall
        [MethodId(20301)]
        Result GetNintendoNetworkIdInfo(Out<NintendoNetworkIdUserInfo> outUserInfo,
            Out<int32_t> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<NintendoNetworkIdFriendImpl> outFriends,
            nn.account.Uid uid, int32_t type);

        // ver.5.0.0
        // AsyncCall
        [MethodId(20302)]
        Result GetSnsAccountLinkage(Out<SnsAccountLinkage> outLinkage,
            nn.account.Uid uid);

        // ver.5.0.0
        // AsyncCall
        [MethodId(20303)]
        Result GetSnsAccountProfile(Out<SnsAccountProfile> outProfile,
            nn.account.Uid uid, nn.account.NetworkServiceAccountId accountId, int32_t type);

        // ver.5.0.0
        // AsyncCall
        [MethodId(20304)]
        Result GetSnsAccountFriendList(Out<int32_t> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<SnsAccountFriendImpl> outFriends,
            nn.account.Uid uid, int32_t type);

        [MethodId(20400)]
        Result GetBlockedUserList(Out<int32_t> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<BlockedUserImpl> outUsers,
            nn.account.Uid uid, int32_t offset);

        // AsyncCall
        [MethodId(20401)]
        Result SyncBlockedUserList(nn.account.Uid uid);

        // AsyncCall
        [MethodId(20500)]
        Result GetProfileExtraList([BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<ProfileExtraImpl> outProfiles,
            nn.account.Uid uid, InArray<nn.account.NetworkServiceAccountId> accountIds);

        // AsyncCall
        [MethodId(20501)]
        Result GetRelationship(Out<Relationship> outRelationship,
            nn.account.Uid uid, nn.account.NetworkServiceAccountId accountId);

        [MethodId(20600)]
        Result GetUserPresenceView(Out<UserPresenceViewImpl> outPresence,
            nn.account.Uid uid);

        [MethodId(20700)]
        Result GetPlayHistoryList(Out<int32_t> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<PlayHistoryImpl> outHistories,
            nn.account.Uid uid, int32_t offset);

        [MethodId(20701)]
        Result GetPlayHistoryStatistics(Out<PlayHistoryStatistics> outStatistics,
            nn.account.Uid uid);

        [MethodId(20800)]
        Result LoadUserSetting(Out<UserSettingImpl> outSetting,
            nn.account.Uid uid);

        // AsyncCall
        [MethodId(20801)]
        Result SyncUserSetting(nn.account.Uid uid);

        [MethodId(20900)]
        Result RequestListSummaryOverlayNotification();

        [MethodId(21000)]
        Result GetExternalApplicationCatalog(Out<ExternalApplicationCatalog> outCatalog,
            ExternalApplicationCatalogId catalogId, settings.LanguageCode language);
    }

    ////////////////////////////////////////////////////////////////////////////////
    // Manager API
    ////////////////////////////////////////////////////////////////////////////////
    public partial interface IFriendService : IServiceObject
    {
        [MethodId(30100)]
        Result DropFriendNewlyFlags(nn.account.Uid uid);

        // AsyncCall
        [MethodId(30101)]
        Result DeleteFriend(nn.account.Uid uid, nn.account.NetworkServiceAccountId accountId);

        [MethodId(30110)]
        Result DropFriendNewlyFlag(nn.account.Uid uid, nn.account.NetworkServiceAccountId accountId);

        // AsyncCall
        [MethodId(30120)]
        Result ChangeFriendFavoriteFlag(nn.account.Uid uid, nn.account.NetworkServiceAccountId accountId, bool newValue);

        // AsyncCall
        [MethodId(30121)]
        Result ChangeFriendOnlineNotificationFlag(nn.account.Uid uid, nn.account.NetworkServiceAccountId accountId, bool newValue);

        // AsyncCall
        [MethodId(30200)]
        Result SendFriendRequest(nn.account.Uid uid, nn.account.NetworkServiceAccountId accountId, int32_t requestType);

        // AsyncCall
        [MethodId(30201)]
        Result SendFriendRequestWithApplicationInfo(nn.account.Uid uid, nn.account.NetworkServiceAccountId accountId, int32_t requestType,
            ApplicationInfo appInfo, InAppScreenName inAppScreenName, InAppScreenName myInAppScreenName);

        // ver.2.0.0
        // AsyncCall
        [MethodId(30215)]
        Result SendFriendRequestWithExternalApplicationCatalogId(nn.account.Uid uid, nn.account.NetworkServiceAccountId accountId, int32_t requestType,
            ExternalApplicationCatalogId catalogId, InAppScreenName inAppScreenName, InAppScreenName myInAppScreenName);

        // ver.3.0.0
        // AsyncCall
        [MethodId(30217)]
        Result SendFriendRequestWithNintendoNetworkIdInfo(nn.account.Uid uid, nn.account.NetworkServiceAccountId accountId, int32_t requestType,
            MiiName miiName, MiiImageUrlParam miiImageUrlParam, MiiName myMiiName, MiiImageUrlParam myMiiImageUrlParam);

        // AsyncCall
        [MethodId(30202)]
        Result CancelFriendRequest(nn.account.Uid uid, RequestId requestId);

        // AsyncCall
        [MethodId(30203)]
        Result AcceptFriendRequest(nn.account.Uid uid, RequestId requestId);

        // AsyncCall
        [MethodId(30204)]
        Result RejectFriendRequest(nn.account.Uid uid, RequestId requestId);

        // AsyncCall
        [MethodId(30205)]
        Result ReadFriendRequest(nn.account.Uid uid, RequestId requestId);

        [MethodId(30210)]
        Result GetFacedFriendRequestRegistrationKey(Out<FacedFriendRequestRegistrationKey> outKey,
            nn.account.Uid uid);

        [MethodId(30211)]
        Result AddFacedFriendRequest(nn.account.Uid uid, FacedFriendRequestRegistrationKey key,
            nn.account.Nickname nickname, [BufferTransferMode(BufferTransferMode.MapAlias)] InBuffer image);

        [MethodId(30212)]
        Result CancelFacedFriendRequest(nn.account.Uid uid, nn.account.NetworkServiceAccountId accountId);

        [MethodId(30213)]
        Result GetFacedFriendRequestProfileImage(Out<int32_t> outSize,
            nn.account.Uid uid, nn.account.NetworkServiceAccountId accountId, [BufferTransferMode(BufferTransferMode.MapAlias)] OutBuffer buffer);

        [MethodId(30214)]
        Result GetFacedFriendRequestProfileImageFromPath(Out<int32_t> outSize,
            InArray<char_t> path, [BufferTransferMode(BufferTransferMode.MapAlias)] OutBuffer buffer);

        // [MethodId(30215)]
        // Result SendFriendRequestWithExternalApplicationCatalogId(nn.account.Uid uid, nn.account.NetworkServiceAccountId accountId, int32_t requestType,
        //    ExternalApplicationCatalogId catalogId, InAppScreenName inAppScreenName, InAppScreenName myInAppScreenName);

        // AsyncCall
        [MethodId(30216)]
        Result ResendFacedFriendRequest(nn.account.Uid uid, nn.account.NetworkServiceAccountId accountId);

        // [MethodId(30217)]
        // Result SendFriendRequestWithNintendoNetworkIdInfo(nn.account.Uid uid, nn.account.NetworkServiceAccountId accountId, int32_t requestType,
        //    MiiName miiName, MiiImageUrlParam miiImageUrlParam, MiiName myMiiName, MiiImageUrlParam myMiiImageUrlParam);

        // ver.5.0.0
        // AsyncCall
        [MethodId(30300)]
        Result GetSnsAccountLinkPageUrl([BufferTransferMode(BufferTransferMode.MapAlias)] Out<WebPageUrl> outUrl,
            nn.account.Uid uid, int32_t type);

        // ver.5.0.0
        // AsyncCall
        [MethodId(30301)]
        Result UnlinkSnsAccount(nn.account.Uid uid, int32_t type);

        // AsyncCall
        [MethodId(30400)]
        Result BlockUser(nn.account.Uid uid, nn.account.NetworkServiceAccountId accountId, int32_t blockReason);

        // AsyncCall
        [MethodId(30401)]
        Result BlockUserWithApplicationInfo(nn.account.Uid uid, nn.account.NetworkServiceAccountId accountId, int32_t blockReason,
            ApplicationInfo appInfo, InAppScreenName inAppScreenName);

        // AsyncCall
        [MethodId(30402)]
        Result UnblockUser(nn.account.Uid uid, nn.account.NetworkServiceAccountId accountId);

        // AsyncCall
        [MethodId(30500)]
        Result GetProfileExtraFromFriendCode(Out<ProfileExtraImpl> outProfile,
            nn.account.Uid uid, FriendCode friendCode);

        [MethodId(30700)]
        Result DeletePlayHistory(nn.account.Uid uid);

        // AsyncCall
        [MethodId(30810)]
        Result ChangePresencePermission(nn.account.Uid uid, int32_t newValue);

        // AsyncCall
        [MethodId(30811)]
        Result ChangeFriendRequestReception(nn.account.Uid uid, bool newValue);

        // AsyncCall
        [MethodId(30812)]
        Result ChangePlayLogPermission(nn.account.Uid uid, int32_t newValue);

        // AsyncCall
        [MethodId(30820)]
        Result IssueFriendCode(nn.account.Uid uid);

        // AsyncCall
        [MethodId(30830)]
        Result ClearPlayLog(nn.account.Uid uid);
    }

    ////////////////////////////////////////////////////////////////////////////////
    // System API
    ////////////////////////////////////////////////////////////////////////////////
    public partial interface IFriendService : IServiceObject
    {
        [MethodId(49900)]
        Result DeleteNetworkServiceAccountCache(nn.account.Uid uid);
    }
}

namespace nn.friends.detail.ipc
{
    [CppRefPath(@"<nn/friends/detail/ipc/friends_INotificationService.sfdl.h>")]
    public partial interface INotificationService : IServiceObject
    {
        [MethodId(0)]
        Result GetEvent(Out<NativeHandle> outHandle);

        [MethodId(1)]
        Result Clear();

        [MethodId(2)]
        Result Pop(Out<SizedNotificationInfo> outInfo);
    }
}

namespace nn.friends.detail.ipc
{
    [CppRefPath(@"<nn/friends/detail/ipc/friends_IDaemonSuspendSessionService.sfdl.h>")]
    public partial interface IDaemonSuspendSessionService : IServiceObject
    {
    }
}

namespace nn.friends.detail.ipc
{
    [CppRefPath(@"<nn/friends/detail/ipc/friends_IServiceCreator.sfdl.h>")]
    public interface IServiceCreator : IServiceObject
    {
        [MethodId(0)]
        Result CreateFriendService(Out<IFriendService> outService);

        [MethodId(1)]
        Result CreateNotificationService(Out<INotificationService> outService, nn.account.Uid uid);

        [MethodId(2)]
        Result CreateDaemonSuspendSessionService(Out<IDaemonSuspendSessionService> outService);
    }
}
