﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/friends_Friend.h>
#include <nn/friends/detail/friends_ImplFriend.h>
#include <nn/friends/friends_Api.h>
#include <nn/friends/detail/friends_ApiDetail.h>
#include <nn/friends/detail/friends_ShimLibraryGlobal.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/nn_SdkAssert.h>

#define GET_IMPL() NN_DETAIL_FRIENDS_GET_IMPL(Friend)
#define CONST_GET_IMPL() NN_DETAIL_FRIENDS_CONST_GET_IMPL(Friend)

namespace nn { namespace friends {

Friend::Friend() NN_NOEXCEPT
{
    NN_DETAIL_FRIENDS_CLEAR_IMPL();
}

nn::account::NetworkServiceAccountId Friend::GetAccountId() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->accountId;
}

const nn::account::Nickname& Friend::GetNickname() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->nickname;
}

nn::Result Friend::GetProfileImage(size_t* outSize, void* buffer, size_t size) const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(outSize);

    auto session = detail::ShimLibraryGlobal::GetInstance().GetSyncSession();

    NN_RESULT_DO(detail::CheckUserStatus(CONST_GET_IMPL()->uid));

    int32_t actualSize = 0;

    NN_RESULT_DO(session->GetFriendProfileImage(
        &actualSize,
        CONST_GET_IMPL()->uid,
        CONST_GET_IMPL()->accountId,
        nn::sf::OutBuffer(static_cast<char*>(buffer), size)));

    *outSize = static_cast<size_t>(actualSize);

    NN_RESULT_SUCCESS;
}

const FriendPresence& Friend::GetPresence() const NN_NOEXCEPT
{
    return reinterpret_cast<const FriendPresence&>(CONST_GET_IMPL()->presence);
}

bool Friend::IsFavorite() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->favorite;
}

bool Friend::IsNewly() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->newly;
}

nn::Result Friend::Update() NN_NOEXCEPT
{
    return UpdateFriendInfo(this, CONST_GET_IMPL()->uid, &CONST_GET_IMPL()->accountId, 1);
}

bool Friend::IsValid() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->isValid;
}

}}
