﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/friends_DaemonSuspension.h>
#include <nn/friends/detail/friends_ShimLibraryGlobal.h>

namespace nn { namespace friends {

DaemonSuspension::DaemonSuspension() NN_NOEXCEPT :
    m_pService(nullptr)
{
}

DaemonSuspension::~DaemonSuspension() NN_NOEXCEPT
{
    if (m_pService)
    {
        nn::sf::ReleaseSharedObject(m_pService);
    }
}

void DaemonSuspension::Attach(detail::ipc::IDaemonSuspendSessionService* pService) NN_NOEXCEPT
{
    NN_ABORT_UNLESS(!m_pService);

    m_pService = pService;
}

}}
