﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/util/friends_LanguageCode.h>
#include <nn/util/util_StringUtil.h>

namespace nn { namespace friends { namespace detail { namespace util {

namespace
{
    bool IsAlpha(char c) NN_NOEXCEPT
    {
        return (c >= 'a' && c <= 'z') || (c >= 'A' && c <= 'Z');
    }

    bool IsDigit(char c) NN_NOEXCEPT
    {
        return (c >= '0' && c <= '9');
    }
}

bool VerifyLanguageCode(const nn::settings::LanguageCode& language) NN_NOEXCEPT
{
    int length = nn::util::Strnlen(language.string, sizeof (language.string));

    if (length == 0)
    {
        return true;
    }
    if (length == sizeof (language.string))
    {
        return false;
    }

    int languagePartLength = (language.string[2] == '\0' || language.string[2] == '-') ? 2 : 3;

    for (int i = 0; i < languagePartLength; i++)
    {
        if (!IsAlpha(language.string[i]))
        {
            return false;
        }
    }
    if (language.string[languagePartLength] == '\0')
    {
        return true;
    }
    if (language.string[languagePartLength] != '-')
    {
        return false;
    }

    int offset = languagePartLength + 1;
    int subLength = length - offset;

    if (IsAlpha(language.string[offset]))
    {
        if (!(subLength == 2 || subLength == 4))
        {
            return false;
        }
        for (int i = offset; i < length; i++)
        {
            if (!IsAlpha(language.string[i]))
            {
                return false;
            }
        }
    }
    else
    {
        if (subLength != 3)
        {
            return false;
        }
        for (int i = offset; i < length; i++)
        {
            if (!IsDigit(language.string[i]))
            {
                return false;
            }
        }
    }

    return true;
}

}}}}
