﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/service/friends_ServiceCreator.generic.h>
#include <nn/friends/detail/service/friends_FriendService.generic.h>
#include <nn/friends/detail/service/friends_NotificationService.generic.h>
#include <nn/friends/detail/service/friends_DaemonSuspendSessionService.generic.h>
#include <nn/friends/friends_ResultPrivate.h>
#include <nn/sf/sf_ObjectFactory.h>

namespace nn { namespace friends { namespace detail { namespace service {

ServiceCreatorForGeneric::ServiceCreatorForGeneric() NN_NOEXCEPT
{
}

ServiceCreatorForGeneric::~ServiceCreatorForGeneric() NN_NOEXCEPT
{
}

nn::Result ServiceCreatorForGeneric::CreateFriendService(nn::sf::Out<nn::sf::SharedPointer<nn::friends::detail::ipc::IFriendService>> outService) NN_NOEXCEPT
{
    auto p = nn::sf::ObjectFactory<nn::sf::ExpHeapAllocator::Policy>::
        CreateSharedEmplaced<detail::ipc::IFriendService, FriendServiceForGeneric>(&m_FriendServiceHeap.GetAllocator());

    NN_RESULT_THROW_UNLESS(p, ResultOutOfSessionResource());

    outService.Set(std::move(p));

    NN_RESULT_SUCCESS;
}

nn::Result ServiceCreatorForGeneric::CreateNotificationService(nn::sf::Out<nn::sf::SharedPointer<nn::friends::detail::ipc::INotificationService>> outService, const nn::account::Uid& uid) NN_NOEXCEPT
{
    auto p = nn::sf::ObjectFactory<nn::sf::ExpHeapAllocator::Policy>::
        CreateSharedEmplaced<detail::ipc::INotificationService, NotificationServiceForGeneric>(&m_NotificationServiceHeap.GetAllocator(), uid);

    NN_RESULT_THROW_UNLESS(p, ResultOutOfSessionResource());

    outService.Set(std::move(p));

    NN_RESULT_SUCCESS;
}

nn::Result ServiceCreatorForGeneric::CreateDaemonSuspendSessionService(nn::sf::Out<nn::sf::SharedPointer<nn::friends::detail::ipc::IDaemonSuspendSessionService>> outService) NN_NOEXCEPT
{
    auto p = nn::sf::ObjectFactory<nn::sf::ExpHeapAllocator::Policy>::
        CreateSharedEmplaced<detail::ipc::IDaemonSuspendSessionService, DaemonSuspendSessionServiceForGeneric>(&m_DaemonSuspendSessionServiceHeap.GetAllocator());

    NN_RESULT_THROW_UNLESS(p, ResultOutOfSessionResource());

    outService.Set(std::move(p));

    NN_RESULT_SUCCESS;
}

}}}}
