﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/service/friends_FriendService.generic.h>
#include <nn/friends/friends_Result.h>

namespace nn { namespace friends { namespace detail { namespace service {

FriendServiceForGeneric::FriendServiceForGeneric() NN_NOEXCEPT :
    m_IsCompletionEventCreated(false)
{
}

FriendServiceForGeneric::~FriendServiceForGeneric() NN_NOEXCEPT
{
    if (m_IsCompletionEventCreated)
    {
        m_CompletionEvent.Signal();
    }
}

nn::Result FriendServiceForGeneric::GetCompletionEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
{
    if (!m_IsCompletionEventCreated)
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::os::CreateSystemEvent(m_CompletionEvent.GetBase(),
            nn::os::EventClearMode_ManualClear, true));

        m_IsCompletionEventCreated = true;
    }

    outHandle.Set(nn::sf::NativeHandle(m_CompletionEvent.DetachReadableHandle(), false));

    NN_RESULT_SUCCESS;
}

nn::Result FriendServiceForGeneric::Cancel() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

nn::Result FriendServiceForGeneric::GetFriendListIds(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::account::NetworkServiceAccountId>& outAccountIds,
    const nn::account::Uid& uid, std::int32_t offset, const nn::friends::detail::ipc::SizedFriendFilter& filter, nn::Bit64 processId) NN_NOEXCEPT
{
    NN_UNUSED(outAccountIds);
    NN_UNUSED(uid);
    NN_UNUSED(offset);
    NN_UNUSED(filter);
    NN_UNUSED(processId);

    *outCount = 0;

    NN_RESULT_SUCCESS;
}

nn::Result FriendServiceForGeneric::GetFriendList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::FriendImpl>& outFriends,
    const nn::account::Uid& uid, std::int32_t offset, const nn::friends::detail::ipc::SizedFriendFilter& filter, nn::Bit64 processId) NN_NOEXCEPT
{
    NN_UNUSED(outFriends);
    NN_UNUSED(uid);
    NN_UNUSED(offset);
    NN_UNUSED(filter);
    NN_UNUSED(processId);

    *outCount = 0;

    NN_RESULT_SUCCESS;
}

nn::Result FriendServiceForGeneric::UpdateFriendInfo(const nn::sf::OutArray<nn::friends::detail::FriendImpl>& outFriends,
    const nn::account::Uid& uid, const nn::sf::InArray<nn::account::NetworkServiceAccountId>& accountIds, nn::Bit64 processId) NN_NOEXCEPT
{
    NN_UNUSED(outFriends);
    NN_UNUSED(uid);
    NN_UNUSED(accountIds);
    NN_UNUSED(processId);

    NN_RESULT_SUCCESS;
}

nn::Result FriendServiceForGeneric::GetFriendProfileImage(nn::sf::Out<std::int32_t> outSize,
    const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT
{
    NN_UNUSED(outSize);
    NN_UNUSED(uid);
    NN_UNUSED(accountId);
    NN_UNUSED(buffer);

    NN_RESULT_THROW(ResultProfileImageCacheNotFound());
}

nn::Result FriendServiceForGeneric::SendFriendRequestForApplication(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId,
    const nn::friends::InAppScreenName& inAppScreenName, const nn::friends::InAppScreenName& myInAppScreenName, nn::Bit64 processId) NN_NOEXCEPT
{
    NN_UNUSED(uid);
    NN_UNUSED(accountId);
    NN_UNUSED(inAppScreenName);
    NN_UNUSED(myInAppScreenName);
    NN_UNUSED(processId);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result FriendServiceForGeneric::AddFacedFriendRequestForApplication(const nn::account::Uid& uid,
    const nn::friends::FacedFriendRequestRegistrationKey& key,
    const nn::account::Nickname& nickname, const nn::sf::InBuffer& image,
    const nn::friends::InAppScreenName& inAppScreenName, const nn::friends::InAppScreenName& myInAppScreenName, nn::Bit64 processId) NN_NOEXCEPT
{
    NN_UNUSED(uid);
    NN_UNUSED(key);
    NN_UNUSED(nickname);
    NN_UNUSED(image);
    NN_UNUSED(inAppScreenName);
    NN_UNUSED(myInAppScreenName);
    NN_UNUSED(processId);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result FriendServiceForGeneric::GetBlockedUserListIds(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::account::NetworkServiceAccountId>& outAccountIds,
    const nn::account::Uid& uid, std::int32_t offset) NN_NOEXCEPT
{
    NN_UNUSED(outAccountIds);
    NN_UNUSED(uid);
    NN_UNUSED(offset);

    *outCount = 0;

    NN_RESULT_SUCCESS;
}

nn::Result FriendServiceForGeneric::GetProfileList(const nn::sf::OutArray<nn::friends::detail::ProfileImpl>& outProfiles,
    const nn::account::Uid& uid, const nn::sf::InArray<nn::account::NetworkServiceAccountId>& accountIds) NN_NOEXCEPT
{
    NN_UNUSED(outProfiles);
    NN_UNUSED(uid);
    NN_UNUSED(accountIds);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result FriendServiceForGeneric::DeclareOpenOnlinePlaySession(const nn::account::Uid& uid) NN_NOEXCEPT
{
    NN_UNUSED(uid);

    NN_RESULT_SUCCESS;
}

nn::Result FriendServiceForGeneric::DeclareCloseOnlinePlaySession(const nn::account::Uid& uid) NN_NOEXCEPT
{
    NN_UNUSED(uid);

    NN_RESULT_SUCCESS;
}

nn::Result FriendServiceForGeneric::UpdateUserPresence(const nn::account::Uid& uid, const nn::friends::detail::UserPresenceImpl& presence, nn::Bit64 processId) NN_NOEXCEPT
{
    NN_UNUSED(uid);
    NN_UNUSED(presence);
    NN_UNUSED(processId);

    NN_RESULT_SUCCESS;
}

nn::Result FriendServiceForGeneric::GetPlayHistoryRegistrationKey(nn::sf::Out<nn::friends::PlayHistoryRegistrationKey> outKey, const nn::account::Uid& uid, bool isLocalPlay) NN_NOEXCEPT
{
    NN_UNUSED(uid);
    NN_UNUSED(isLocalPlay);

    std::memset(outKey.GetPointer(), 0, sizeof (PlayHistoryRegistrationKey));

    NN_RESULT_SUCCESS;
}

nn::Result FriendServiceForGeneric::GetPlayHistoryRegistrationKeyWithNetworkServiceAccountId(nn::sf::Out<nn::friends::PlayHistoryRegistrationKey> outKey, nn::account::NetworkServiceAccountId accountId, bool isLocalPlay) NN_NOEXCEPT
{
    NN_UNUSED(accountId);
    NN_UNUSED(isLocalPlay);

    std::memset(outKey.GetPointer(), 0, sizeof (PlayHistoryRegistrationKey));

    NN_RESULT_SUCCESS;
}

nn::Result FriendServiceForGeneric::AddPlayHistory(const nn::account::Uid& uid, const nn::friends::PlayHistoryRegistrationKey& key,
    const nn::friends::InAppScreenName& inAppScreenName, const nn::friends::InAppScreenName& myInAppScreenName, nn::Bit64 processId) NN_NOEXCEPT
{
    NN_UNUSED(uid);
    NN_UNUSED(key);
    NN_UNUSED(inAppScreenName);
    NN_UNUSED(myInAppScreenName);
    NN_UNUSED(processId);

    NN_RESULT_SUCCESS;
}

nn::Result FriendServiceForGeneric::GetProfileImageUrl(nn::sf::Out<nn::friends::Url> outUrl, const nn::friends::Url& url, std::int32_t imageSize) NN_NOEXCEPT
{
    NN_UNUSED(imageSize);

    *outUrl = url;

    NN_RESULT_SUCCESS;
}

nn::Result FriendServiceForGeneric::GetFriendCount(nn::sf::Out<std::int32_t> outCount,
    const nn::account::Uid& uid, const nn::friends::detail::ipc::SizedFriendFilter& filter, nn::Bit64 processId) NN_NOEXCEPT
{
    NN_UNUSED(uid);
    NN_UNUSED(filter);
    NN_UNUSED(processId);

    *outCount = 0;

    NN_RESULT_SUCCESS;
}

nn::Result FriendServiceForGeneric::GetNewlyFriendCount(nn::sf::Out<std::int32_t> outCount,
    const nn::account::Uid& uid) NN_NOEXCEPT
{
    NN_UNUSED(uid);

    *outCount = 0;

    NN_RESULT_SUCCESS;
}

nn::Result FriendServiceForGeneric::GetFriendDetailedInfo(nn::sf::Out<nn::friends::detail::FriendDetailedInfoImpl> outInfo,
    const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT
{
    NN_UNUSED(outInfo);
    NN_UNUSED(uid);
    NN_UNUSED(accountId);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result FriendServiceForGeneric::SyncFriendList(const nn::account::Uid& uid) NN_NOEXCEPT
{
    NN_UNUSED(uid);

    NN_RESULT_SUCCESS;
}

nn::Result FriendServiceForGeneric::RequestSyncFriendList(const nn::account::Uid& uid) NN_NOEXCEPT
{
    NN_UNUSED(uid);

    NN_RESULT_SUCCESS;
}

nn::Result FriendServiceForGeneric::LoadFriendSetting(nn::sf::Out<nn::friends::detail::FriendSettingImpl> outSetting, const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT
{
    NN_UNUSED(outSetting);
    NN_UNUSED(uid);
    NN_UNUSED(accountId);

    NN_RESULT_SUCCESS;
}

nn::Result FriendServiceForGeneric::GetReceivedFriendRequestCount(nn::sf::Out<std::int32_t> outUnreadCount, nn::sf::Out<std::int32_t> outReadCount,
    const nn::account::Uid& uid) NN_NOEXCEPT
{
    NN_UNUSED(uid);

    *outUnreadCount = 0;
    *outReadCount = 0;

    NN_RESULT_SUCCESS;
}

nn::Result FriendServiceForGeneric::GetFriendRequestList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::FriendRequestImpl>& outRequests,
    const nn::account::Uid& uid, std::int32_t offset, std::int32_t listType) NN_NOEXCEPT
{
    NN_UNUSED(outRequests);
    NN_UNUSED(uid);
    NN_UNUSED(offset);
    NN_UNUSED(listType);

    *outCount = 0;

    NN_RESULT_SUCCESS;
}

nn::Result FriendServiceForGeneric::GetFriendCandidateList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::FriendCandidateImpl>& outCandidates,
    const nn::account::Uid& uid, std::int32_t type) NN_NOEXCEPT
{
    NN_UNUSED(outCandidates);
    NN_UNUSED(uid);
    NN_UNUSED(type);

    *outCount = 0;

    NN_RESULT_SUCCESS;
}

nn::Result FriendServiceForGeneric::GetNintendoNetworkIdInfo(nn::sf::Out<nn::friends::NintendoNetworkIdUserInfo> outUserInfo,
    nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::NintendoNetworkIdFriendImpl>& outFriends, const nn::account::Uid& uid, std::int32_t type) NN_NOEXCEPT
{
    NN_UNUSED(outFriends);
    NN_UNUSED(uid);
    NN_UNUSED(type);

    std::memset(outUserInfo.GetPointer(), 0, sizeof (NintendoNetworkIdUserInfo));
    *outCount = 0;

    NN_RESULT_SUCCESS;
}

nn::Result FriendServiceForGeneric::GetSnsAccountLinkage(nn::sf::Out<nn::friends::SnsAccountLinkage> outLinkage,
    const nn::account::Uid& uid) NN_NOEXCEPT
{
    NN_UNUSED(outLinkage);
    NN_UNUSED(uid);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result FriendServiceForGeneric::GetSnsAccountProfile(nn::sf::Out<nn::friends::SnsAccountProfile> outProfile,
    const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t type) NN_NOEXCEPT
{
    NN_UNUSED(outProfile);
    NN_UNUSED(uid);
    NN_UNUSED(accountId);
    NN_UNUSED(type);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result FriendServiceForGeneric::GetSnsAccountFriendList(nn::sf::Out<std::int32_t> outCount,
    const nn::sf::OutArray<nn::friends::detail::SnsAccountFriendImpl>& outFriends, const nn::account::Uid& uid, std::int32_t type) NN_NOEXCEPT
{
    NN_UNUSED(outFriends);
    NN_UNUSED(uid);
    NN_UNUSED(type);

    *outCount = 0;

    NN_RESULT_SUCCESS;
}

nn::Result FriendServiceForGeneric::GetBlockedUserList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::BlockedUserImpl>& outUsers,
    const nn::account::Uid& uid, std::int32_t offset) NN_NOEXCEPT
{
    NN_UNUSED(outUsers);
    NN_UNUSED(uid);
    NN_UNUSED(offset);

    *outCount = 0;

    NN_RESULT_SUCCESS;
}

nn::Result FriendServiceForGeneric::SyncBlockedUserList(const nn::account::Uid& uid) NN_NOEXCEPT
{
    NN_UNUSED(uid);

    NN_RESULT_SUCCESS;
}

nn::Result FriendServiceForGeneric::GetProfileExtraList(const nn::sf::OutArray<nn::friends::detail::ProfileExtraImpl>& outProfiles,
    const nn::account::Uid& uid, const nn::sf::InArray<nn::account::NetworkServiceAccountId>& accountIds) NN_NOEXCEPT
{
    NN_UNUSED(outProfiles);
    NN_UNUSED(uid);
    NN_UNUSED(accountIds);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result FriendServiceForGeneric::GetRelationship(nn::sf::Out<nn::friends::Relationship> outRelationship,
    const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT
{
    NN_UNUSED(outRelationship);
    NN_UNUSED(uid);
    NN_UNUSED(accountId);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result FriendServiceForGeneric::GetUserPresenceView(nn::sf::Out<nn::friends::detail::UserPresenceViewImpl> outPresence,
    const nn::account::Uid& uid) NN_NOEXCEPT
{
    NN_UNUSED(uid);

    std::memset(outPresence.GetPointer(), 0, sizeof (UserPresenceViewImpl));

    NN_RESULT_SUCCESS;
}

nn::Result FriendServiceForGeneric::GetPlayHistoryList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::PlayHistoryImpl>& outHistories,
    const nn::account::Uid& uid, std::int32_t offset) NN_NOEXCEPT
{
    NN_UNUSED(outHistories);
    NN_UNUSED(uid);
    NN_UNUSED(offset);

    *outCount = 0;

    NN_RESULT_SUCCESS;
}

nn::Result FriendServiceForGeneric::GetPlayHistoryStatistics(nn::sf::Out<nn::friends::PlayHistoryStatistics> outStatistics,
    const nn::account::Uid& uid) NN_NOEXCEPT
{
    NN_UNUSED(uid);

    std::memset(outStatistics.GetPointer(), 0, sizeof (PlayHistoryStatistics));

    NN_RESULT_SUCCESS;
}

nn::Result FriendServiceForGeneric::LoadUserSetting(nn::sf::Out<nn::friends::detail::UserSettingImpl> outSetting,
    const nn::account::Uid& uid) NN_NOEXCEPT
{
    NN_UNUSED(uid);

    std::memset(outSetting.GetPointer(), 0, sizeof (UserSettingImpl));

    NN_RESULT_SUCCESS;
}

nn::Result FriendServiceForGeneric::SyncUserSetting(const nn::account::Uid& uid) NN_NOEXCEPT
{
    NN_UNUSED(uid);

    NN_RESULT_SUCCESS;
}

nn::Result FriendServiceForGeneric::RequestListSummaryOverlayNotification() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

nn::Result FriendServiceForGeneric::GetExternalApplicationCatalog(nn::sf::Out<nn::friends::ExternalApplicationCatalog> outCatalog,
    const nn::friends::ExternalApplicationCatalogId& catalogId, nn::settings::LanguageCode language) NN_NOEXCEPT
{
    NN_UNUSED(outCatalog);
    NN_UNUSED(catalogId);
    NN_UNUSED(language);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result FriendServiceForGeneric::DropFriendNewlyFlags(const nn::account::Uid& uid) NN_NOEXCEPT
{
    NN_UNUSED(uid);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result FriendServiceForGeneric::DeleteFriend(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT
{
    NN_UNUSED(uid);
    NN_UNUSED(accountId);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result FriendServiceForGeneric::DropFriendNewlyFlag(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT
{
    NN_UNUSED(uid);
    NN_UNUSED(accountId);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result FriendServiceForGeneric::ChangeFriendFavoriteFlag(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, bool newValue) NN_NOEXCEPT
{
    NN_UNUSED(uid);
    NN_UNUSED(accountId);
    NN_UNUSED(newValue);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result FriendServiceForGeneric::ChangeFriendOnlineNotificationFlag(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, bool newValue) NN_NOEXCEPT
{
    NN_UNUSED(uid);
    NN_UNUSED(accountId);
    NN_UNUSED(newValue);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result FriendServiceForGeneric::SendFriendRequest(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t requestType) NN_NOEXCEPT
{
    NN_UNUSED(uid);
    NN_UNUSED(accountId);
    NN_UNUSED(requestType);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result FriendServiceForGeneric::SendFriendRequestWithApplicationInfo(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t requestType,
    const nn::friends::ApplicationInfo& appInfo, const nn::friends::InAppScreenName& inAppScreenName, const nn::friends::InAppScreenName& myInAppScreenName) NN_NOEXCEPT
{
    NN_UNUSED(uid);
    NN_UNUSED(accountId);
    NN_UNUSED(requestType);
    NN_UNUSED(appInfo);
    NN_UNUSED(inAppScreenName);
    NN_UNUSED(myInAppScreenName);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result FriendServiceForGeneric::SendFriendRequestWithExternalApplicationCatalogId(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t requestType,
    const nn::friends::ExternalApplicationCatalogId& catalogId, const nn::friends::InAppScreenName& inAppScreenName, const nn::friends::InAppScreenName& myInAppScreenName) NN_NOEXCEPT
{
    NN_UNUSED(uid);
    NN_UNUSED(accountId);
    NN_UNUSED(requestType);
    NN_UNUSED(catalogId);
    NN_UNUSED(inAppScreenName);
    NN_UNUSED(myInAppScreenName);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result FriendServiceForGeneric::SendFriendRequestWithNintendoNetworkIdInfo(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t requestType,
    const nn::friends::MiiName& miiName, const nn::friends::MiiImageUrlParam& miiImageUrlParam, const nn::friends::MiiName& myMiiName, const nn::friends::MiiImageUrlParam& myMiiImageUrlParam) NN_NOEXCEPT
{
    NN_UNUSED(uid);
    NN_UNUSED(accountId);
    NN_UNUSED(requestType);
    NN_UNUSED(miiName);
    NN_UNUSED(miiImageUrlParam);
    NN_UNUSED(myMiiName);
    NN_UNUSED(myMiiImageUrlParam);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result FriendServiceForGeneric::CancelFriendRequest(const nn::account::Uid& uid, nn::friends::RequestId requestId) NN_NOEXCEPT
{
    NN_UNUSED(uid);
    NN_UNUSED(requestId);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result FriendServiceForGeneric::AcceptFriendRequest(const nn::account::Uid& uid, nn::friends::RequestId requestId) NN_NOEXCEPT
{
    NN_UNUSED(uid);
    NN_UNUSED(requestId);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result FriendServiceForGeneric::RejectFriendRequest(const nn::account::Uid& uid, nn::friends::RequestId requestId) NN_NOEXCEPT
{
    NN_UNUSED(uid);
    NN_UNUSED(requestId);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result FriendServiceForGeneric::ReadFriendRequest(const nn::account::Uid& uid, nn::friends::RequestId requestId) NN_NOEXCEPT
{
    NN_UNUSED(uid);
    NN_UNUSED(requestId);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result FriendServiceForGeneric::GetFacedFriendRequestRegistrationKey(nn::sf::Out<nn::friends::FacedFriendRequestRegistrationKey> outKey,
    const nn::account::Uid& uid) NN_NOEXCEPT
{
    NN_UNUSED(outKey);
    NN_UNUSED(uid);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result FriendServiceForGeneric::AddFacedFriendRequest(const nn::account::Uid& uid,
    const nn::friends::FacedFriendRequestRegistrationKey& key,
    const nn::account::Nickname& nickname, const nn::sf::InBuffer& image) NN_NOEXCEPT
{
    NN_UNUSED(uid);
    NN_UNUSED(key);
    NN_UNUSED(nickname);
    NN_UNUSED(image);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result FriendServiceForGeneric::CancelFacedFriendRequest(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT
{
    NN_UNUSED(uid);
    NN_UNUSED(accountId);

    NN_RESULT_SUCCESS;
}

nn::Result FriendServiceForGeneric::GetFacedFriendRequestProfileImage(nn::sf::Out<std::int32_t> outSize,
    const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT
{
    NN_UNUSED(outSize);
    NN_UNUSED(uid);
    NN_UNUSED(accountId);
    NN_UNUSED(buffer);

    NN_RESULT_THROW(ResultProfileImageCacheNotFound());
}

nn::Result FriendServiceForGeneric::GetFacedFriendRequestProfileImageFromPath(nn::sf::Out<std::int32_t> outSize,
    const nn::sf::InArray<char>& path, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT
{
    NN_UNUSED(outSize);
    NN_UNUSED(path);
    NN_UNUSED(buffer);

    NN_RESULT_THROW(ResultProfileImageCacheNotFound());
}

nn::Result FriendServiceForGeneric::ResendFacedFriendRequest(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT
{
    NN_UNUSED(uid);
    NN_UNUSED(accountId);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result FriendServiceForGeneric::GetSnsAccountLinkPageUrl(nn::sf::Out<nn::friends::WebPageUrl> outUrl,
    const nn::account::Uid& uid, std::int32_t type) NN_NOEXCEPT
{
    NN_UNUSED(outUrl);
    NN_UNUSED(uid);
    NN_UNUSED(type);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result FriendServiceForGeneric::UnlinkSnsAccount(const nn::account::Uid& uid, std::int32_t type) NN_NOEXCEPT
{
    NN_UNUSED(uid);
    NN_UNUSED(type);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result FriendServiceForGeneric::BlockUser(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t blockReason) NN_NOEXCEPT
{
    NN_UNUSED(uid);
    NN_UNUSED(accountId);
    NN_UNUSED(blockReason);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result FriendServiceForGeneric::BlockUserWithApplicationInfo(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t blockReason, const nn::friends::ApplicationInfo& appInfo, const nn::friends::InAppScreenName& inAppScreenName) NN_NOEXCEPT
{
    NN_UNUSED(uid);
    NN_UNUSED(accountId);
    NN_UNUSED(blockReason);
    NN_UNUSED(appInfo);
    NN_UNUSED(inAppScreenName);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result FriendServiceForGeneric::UnblockUser(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT
{
    NN_UNUSED(uid);
    NN_UNUSED(accountId);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result FriendServiceForGeneric::GetProfileExtraFromFriendCode(nn::sf::Out<nn::friends::detail::ProfileExtraImpl> outProfile,
    const nn::account::Uid& uid, const nn::friends::FriendCode& friendCode) NN_NOEXCEPT
{
    NN_UNUSED(outProfile);
    NN_UNUSED(uid);
    NN_UNUSED(friendCode);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result FriendServiceForGeneric::DeletePlayHistory(const nn::account::Uid& uid) NN_NOEXCEPT
{
    NN_UNUSED(uid);

    NN_RESULT_SUCCESS;
}

nn::Result FriendServiceForGeneric::ChangePresencePermission(const nn::account::Uid& uid, std::int32_t newValue) NN_NOEXCEPT
{
    NN_UNUSED(uid);
    NN_UNUSED(newValue);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result FriendServiceForGeneric::ChangeFriendRequestReception(const nn::account::Uid& uid, bool newValue) NN_NOEXCEPT
{
    NN_UNUSED(uid);
    NN_UNUSED(newValue);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result FriendServiceForGeneric::ChangePlayLogPermission(const nn::account::Uid& uid, std::int32_t newValue) NN_NOEXCEPT
{
    NN_UNUSED(uid);
    NN_UNUSED(newValue);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result FriendServiceForGeneric::IssueFriendCode(const nn::account::Uid& uid) NN_NOEXCEPT
{
    NN_UNUSED(uid);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result FriendServiceForGeneric::ClearPlayLog(const nn::account::Uid& uid) NN_NOEXCEPT
{
    NN_UNUSED(uid);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result FriendServiceForGeneric::DeleteNetworkServiceAccountCache(const nn::account::Uid& uid) NN_NOEXCEPT
{
    NN_UNUSED(uid);

    NN_RESULT_THROW(ResultNotImplemented());
}

}}}}
