﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/service/friends_DaemonSuspendSessionService.h>
#include <nn/friends/detail/service/core/friends_BackgroundTaskThread.h>
#include <nn/friends/detail/service/core/friends_EventWatcher.h>

namespace nn { namespace friends { namespace detail { namespace service {

DaemonSuspendSessionService::DaemonSuspendSessionService(const Capability& capability) NN_NOEXCEPT :
    m_Capability(capability)
{
    if (m_Capability.IsPermitted(Capability::Flag_Management | Capability::Flag_System))
    {
        detail::service::core::BackgroundTaskThread::Suspend();
        detail::service::core::EventWatcher::Suspend();
    }
    else
    {
        NN_DETAIL_FRIENDS_INFO("[friends] There is no permission to call SuspendDaemon.\n");
    }
}

DaemonSuspendSessionService::~DaemonSuspendSessionService() NN_NOEXCEPT
{
    if (m_Capability.IsPermitted(Capability::Flag_Management | Capability::Flag_System))
    {
        detail::service::core::EventWatcher::Resume();
        detail::service::core::BackgroundTaskThread::Resume();
    }
}

}}}}
