﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/service/core/task/friends_TaskGetExternalApplicationCatalog.h>
#include <nn/friends/detail/service/core/handler/friends_HandlerExternalApplicationCatalog.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

GetExternalApplicationCatalogTask::GetExternalApplicationCatalogTask() NN_NOEXCEPT :
    m_IsParameterSet(false),
    m_OutCatalog(nullptr)
{
}

nn::Result GetExternalApplicationCatalogTask::SetParameter(ExternalApplicationCatalog* outCatalog,
        const ExternalApplicationCatalogId& catalogId, const nn::settings::LanguageCode& language) NN_NOEXCEPT
{
    m_OutCatalog = outCatalog;
    m_CatalogId = catalogId;
    m_Language = language;

    m_IsParameterSet = true;

    NN_RESULT_SUCCESS;
}

nn::Result GetExternalApplicationCatalogTask::Main() NN_NOEXCEPT
{
    NN_SDK_ASSERT(m_IsParameterSet);

    NN_RESULT_DO(StepGet());

    NN_RESULT_SUCCESS;
}

nn::Result GetExternalApplicationCatalogTask::StepGet() NN_NOEXCEPT
{
    NN_DETAIL_FRIENDS_INFO("[friends] GetExternalApplicationCatalogTask::StepGet ...\n");

    detail::service::json::JsonHttpInputStream stream;

    char url[160] = {};
    nn::util::SNPrintf(url, sizeof (url),
        "https://c-%%.accounts.nintendo.com/v1/apps/%016llx%016llx/catalog.json", m_CatalogId.value[0], m_CatalogId.value[1]);

    NN_RESULT_DO(stream.Open("GET", url));

    ExternalApplicationCatalogHandler handler;
    handler.Initialize(m_OutCatalog, m_Language);

    NN_RESULT_DO(WebApi::Call(handler, stream, GetUid(), GetCancelable(), false));

    NN_RESULT_SUCCESS;
}

}}}}}
