﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/service/core/handler/friends_HandlerNintendoNetworkIdInfoResource.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

NintendoNetworkIdInfoResourceHandler::NintendoNetworkIdInfoResourceHandler() NN_NOEXCEPT :
    m_OutUserInfo(nullptr),
    m_OutCount(0),
    m_OutFriends(nullptr),
    m_Count(0),
    m_Index(0),
    m_UserInfoBits()
{
}

void NintendoNetworkIdInfoResourceHandler::Initialize(NintendoNetworkIdUserInfo* outUserInfo, int* outCount, NintendoNetworkIdFriendImpl* outFriends,
    int count) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(outUserInfo);
    NN_SDK_REQUIRES_NOT_NULL(outCount);
    NN_SDK_REQUIRES_NOT_NULL(outFriends);
    NN_SDK_REQUIRES(count > 0);

    m_OutUserInfo = outUserInfo;
    m_OutCount = outCount;
    m_OutFriends = outFriends;

    m_Count = count;

    std::memset(m_OutUserInfo, 0, sizeof (NintendoNetworkIdUserInfo));
    std::memset(m_OutFriends, 0, sizeof (NintendoNetworkIdFriendImpl) * m_Count);
}

bool NintendoNetworkIdInfoResourceHandler::OnStartObject(const detail::service::json::JsonPath& jsonPath) NN_NOEXCEPT
{
    if (jsonPath.Match("$.items[*]"))
    {
        std::memset(&m_Friend, 0, sizeof (m_Friend));
        std::memset(&m_FriendBits, 0, sizeof (m_FriendBits));
    }

    return true;
}

bool NintendoNetworkIdInfoResourceHandler::OnEndObject(const detail::service::json::JsonPath& jsonPath, size_t numObjects) NN_NOEXCEPT
{
    NN_UNUSED(numObjects);

    if (jsonPath.Match("$.items[*]"))
    {
        if (m_FriendBits.accountId && m_FriendBits.miiName && m_FriendBits.miiImageUrlParam)
        {
            m_Friend.data.isValid = true;

            if (m_Index < m_Count)
            {
                std::memcpy(&m_OutFriends[m_Index], &m_Friend, sizeof (NintendoNetworkIdFriendImpl));
                m_Index++;
            }
        }
    }

    return true;
}

bool NintendoNetworkIdInfoResourceHandler::OnEndArray(const detail::service::json::JsonPath& jsonPath, size_t numElements) NN_NOEXCEPT
{
    NN_UNUSED(numElements);

    if (jsonPath.Compare("$.items[]"))
    {
        *m_OutCount = m_Index;
    }

    return true;
}

bool NintendoNetworkIdInfoResourceHandler::OnInteger(const detail::service::json::JsonPath& jsonPath, const detail::service::json::AnyInteger& value) NN_NOEXCEPT
{
    if (!m_UserInfoBits.friendCount &&
        jsonPath.Compare("$.original_count"))
    {
        m_OutUserInfo->friendCount = static_cast<int32_t>(value.s);
        m_UserInfoBits.friendCount = true;
    }

    return true;
}

bool NintendoNetworkIdInfoResourceHandler::OnString(const detail::service::json::JsonPath& jsonPath, const char* value, size_t length, bool isOverflowed) NN_NOEXCEPT
{
    NN_UNUSED(isOverflowed);

    if (!m_FriendBits.accountId &&
        jsonPath.Match("$.items[*].id"))
    {
        nn::account::NetworkServiceAccountId accountId;

        if (detail::util::HexToNumber(&accountId.id, value))
        {
            m_Friend.data.accountId = accountId;
            m_FriendBits.accountId = true;
        }
    }
    else if (!m_FriendBits.miiName &&
        jsonPath.Match("$.items[*].nickname"))
    {
        nn::util::CopyUtf8String(m_Friend.data.miiName.value, sizeof (m_Friend.data.miiName.value),
            value, length, MiiNameLengthMax);
        m_FriendBits.miiName = true;
    }
    else if (!m_FriendBits.miiImageUrlParam &&
        jsonPath.Match("$.items[*].mii_image_url_param"))
    {
        nn::util::Strlcpy(m_Friend.data.miiImageUrlParam.value, value, sizeof (m_Friend.data.miiImageUrlParam.value));
        m_FriendBits.miiImageUrlParam = true;
    }
    else if (!m_UserInfoBits.miiName &&
        jsonPath.Compare("$.user.nickname"))
    {
        nn::util::CopyUtf8String(m_OutUserInfo->miiName.value, sizeof (m_OutUserInfo->miiName.value),
            value, length, MiiNameLengthMax);
        m_UserInfoBits.miiName = true;
    }
    else if (!m_UserInfoBits.miiImageUrlParam &&
        jsonPath.Compare("$.user.mii_image_url_param"))
    {
        nn::util::Strlcpy(m_OutUserInfo->miiImageUrlParam.value, value, sizeof (m_OutUserInfo->miiImageUrlParam.value));
        m_UserInfoBits.miiImageUrlParam = true;
    }

    return true;
}

}}}}}
