﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/util/util_IntrusiveList.h>
#include <nn/fgm/fgm_Types.h>

#include "fgm_Policy.h"
#include "fgm_RequestManager.h"

namespace nn     {
namespace fgm    {
namespace server {

extern nn::os::Mutex g_ResourceListLock;
extern nn::util::IntrusiveList<Resource, nn::util::IntrusiveListBaseNodeTraits<Resource>> g_ResourceList;

// FGM managed PM resource
class Resource :
      public  nn::util::IntrusiveListBaseNode<Resource>,
      private RequestManager,
      private Policy
{
private:
    nn::os::Mutex m_ResourceLock;
    Module        m_Id;

public:
    virtual nn::Result Set(Setting min, Setting max)
    NN_NOEXCEPT
    {
        return nn::fgm::ResultNotSupported();
    }

    virtual nn::Result Get(Setting* current)
    NN_NOEXCEPT
    {
        return nn::fgm::ResultNotSupported();
    }

    virtual nn::Result OperatingRange(Setting min1, Setting max1, Setting min2, Setting max2, Setting* min, Setting* max)
    NN_NOEXCEPT
    {
        return Policy::OperatingRange(min1, max1, min2, max2, min, max);
    }

    Module     GetId() const NN_NOEXCEPT { return m_Id; };
    nn::Result AddRequest(Request* pRequestIn) NN_NOEXCEPT;
    nn::Result UpdateRequest(Request* pRequestIn, Setting newMin, Setting newMax) NN_NOEXCEPT;
    nn::Result DeleteRequest(Request* pRequestIn) NN_NOEXCEPT;
    nn::Result SetOperatingPoint() NN_NOEXCEPT;
    nn::Result GetOperatingPoint(Setting* pCurrentSettingOut) NN_NOEXCEPT;
    nn::Result Initialize(Setting min, Setting max) NN_NOEXCEPT;
    nn::Result Finalize() NN_NOEXCEPT;

    explicit Resource(Module id) NN_NOEXCEPT;
};

}}}

