﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fgm/fgm_Types.h>

namespace nn     {
namespace fgm    {
namespace server {

class Policy
{
private:
    static bool FullOverlap(Setting min1, Setting max1, Setting min2, Setting max2)
    NN_NOEXCEPT
    {
        return ((min1 <= min2 && max2 <= max1) || (min2 <= min1 && max1 <= max2));
    }

    static bool LeftOverlap(Setting min1, Setting max1, Setting min2, Setting max2)
    NN_NOEXCEPT
    {
        return (min2 <= min1 && min1 <= max2 && max2 <= max1);
    }

    static bool RightOverlap(Setting min1, Setting max1, Setting min2, Setting max2)
    NN_NOEXCEPT
    {
        return (min1 <= min2 && min2 <= max1 && max1 <= max2);
    }

public:
    // Find minimal operating point based on a set of min/max constraints.
    // First range has higher priority.
    virtual nn::Result OperatingRange(Setting min1, Setting max1, Setting min2, Setting max2, Setting* combinedMin, Setting* combinedMax)
    NN_NOEXCEPT
    {
        if (FullOverlap(min1, max1, min2, max2))
        {
            *combinedMin = min1 > min2 ? min1 : min2;
            *combinedMax = max1 < max2 ? max1 : max2;
        }
        else if (LeftOverlap(min1, max1, min2, max2))
        {
            *combinedMax = max2;
            *combinedMin = min1;
        }
        else if (RightOverlap(min1, max1, min2, max2))
        {
            *combinedMin = min2;
            *combinedMax = max1;
        }
        else
        {
            // no overlap, first range wins,
            // but make it as close to the second as possible
            *combinedMin = max1 < min2 ? max1 : min1;
            *combinedMax = *combinedMin;
        }

        return ResultSuccess();
    }
};

}}}
