﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fgm/fgm_Types.h>
#include <nn/fgm/fgm_DebugTypes.h>

#include "fgm_Cbuf.h"

namespace nn     {
namespace fgm    {
namespace server {

class Log :
    public Cbuf<DebugEntry>
{
public:
    nn::Result Write(DebugEntry* pEntryIn) NN_NOEXCEPT;
    nn::Result Read(DebugEntry* pBufferOut, uint32_t toReadCount, uint32_t* pReadCountOut, uint32_t* pLostCountOut, uint32_t* pRemainingCountOut) NN_NOEXCEPT;
    nn::Result Initialize(void* pMemoryIn, size_t memorySize) NN_NOEXCEPT;
    nn::Result Finalize() NN_NOEXCEPT;
};

}}}

