﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_SystemEvent.h>
#include <nn/os/os_TransferMemory.h>
#include <nn/util/util_IntrusiveList.h>

#include <nn/fgm/fgm_DebugTypes.h>
#include <nn/fgm/sfdl/fgm.sfdl.h>

#include "fgm_Log.h"

namespace nn     {
namespace fgm    {
namespace server {

// Implements a debugger.
// Object is linked to client's debugger instance through SF.
class Debugger :
    public nn::util::IntrusiveListBaseNode<Debugger>,
    public nn::sf::ISharedObject,
    public Log
{
private:
    nn::os::TransferMemoryType m_TransferMemory;
    nn::os::SystemEvent        m_SystemEvent;
    bool                       m_Initialized;

public:
    nn::Result Initialize(
                nn::sf::Out<nn::sf::NativeHandle> handleOut,
                nn::sf::NativeHandle handleIn,
                uint64_t memsize
               ) NN_NOEXCEPT;

    nn::Result Read(
                nn::sf::OutBuffer bufferOut,
                nn::sf::Out<uint32_t> numberReadOut,
                nn::sf::Out<uint32_t> numberLostOut,
                nn::sf::Out<uint32_t> numberRemainingOut
               ) NN_NOEXCEPT;

    void       Write(DebugEntry* pEntryIn) NN_NOEXCEPT;
    nn::Result Signal() NN_NOEXCEPT;
    nn::Result Cancel() NN_NOEXCEPT;
    Debugger() NN_NOEXCEPT;
    ~Debugger() NN_NOEXCEPT;
};

void LogEntry(DebugEntry* pEntry) NN_NOEXCEPT;

}}}
