﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/pcv/pcv.h>
#include <nn/psc.h>

#include "fgm_Hardware.tegra-nx.h"
#include "fgm_Hardware.test.h"

namespace nn     {
namespace fgm    {
namespace server {
namespace detail {
namespace        {

NXPCVResource resource[] =
{
      /* fgm id */             /* pcv id */            /* can be disabled? */
    { nn::fgm::Module_Cpu,     nn::pcv::Module_Cpu     , false  },
    { nn::fgm::Module_Gpu,     nn::pcv::Module_Gpu     , false  },
    { nn::fgm::Module_Emc,     nn::pcv::Module_Emc     , false  },
    { nn::fgm::Module_SysBus,  nn::pcv::Module_SysBus  , false  },
    { nn::fgm::Module_Mselect, nn::pcv::Module_Mselect , false  },
    { nn::fgm::Module_Nvdec,   nn::pcv::Module_Nvdec   , true   },
    { nn::fgm::Module_Nvenc,   nn::pcv::Module_Nvenc   , true   },
    { nn::fgm::Module_Nvjpg,   nn::pcv::Module_Nvjpg   , true   }
};

TestResource  testPM(nn::fgm::Module_Test);

extern "C" int NvOsDrvOpen(const char *pathname, int flags);

nn::psc::PmModuleId moduleDependencies[] = {nn::psc::PmModuleId_PcvClock};

} // namespace

nn::Result Initialize(nn::psc::PmModuleId** pDependencyList, uint32_t* pDependencyCount)
NN_NOEXCEPT
{
    nn::Result result;

    nn::pcv::Initialize();

    for (auto i = 0; i < sizeof(resource) / sizeof(resource[0]); i++)
    {
        result = resource[i].Initialize();
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    }

    result = testPM.Initialize();
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);

    *pDependencyList  = moduleDependencies;
    *pDependencyCount = sizeof(moduleDependencies) / sizeof(moduleDependencies[0]);

    return ResultSuccess();
}

}}}}
