﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

namespace nn.fatal
{
    [CppRefPath(@"<nn/fatal/fatal_FatalPolicy.h>")]
    [ExternalStruct(4, 4)]
    public struct FatalPolicy {}
}

namespace nn.fatalsrv
{
    [ExternalStruct(4, 4)]
    [CppRefPath(@"<nn/fatalsrv/fatalsrv_FatalContext.h>")]
    public struct FatalContext {}

    [ExternalStruct(592, 8)]
    [LargeData(true)]
    [CppRefPath(@"<nn/fatalsrv/fatalsrv_CpuContext.h>")]
    public struct CpuContext {}

    public interface IService : IServiceObject
    {
        [MethodId(0)]
        Result ThrowFatal(FatalContext context, [ProcessId] nn.Bit64 id);

        [MethodId(1)]
        Result ThrowFatalWithPolicy(FatalContext context, [ProcessId] nn.Bit64 id, nn.fatal.FatalPolicy policy);

        [MethodId(2)]
        Result ThrowFatalWithCpuContext(
            FatalContext context,
            [ProcessId] nn.Bit64 id,
            nn.fatal.FatalPolicy policy,
            [BufferTransferMode(BufferTransferMode.MapAlias)] CpuContext cpuContext);
    }

    public interface IPrivateService : IServiceObject
    {
        [MethodId(0)]
        Result GetFatalEvent(nn.sf.Out<NativeHandle> outHandle);
    }
}
