﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fatal/detail/fatal_Log.h>

#include "fatalsrv_ThreadContextAccessor.h"

namespace nn { namespace fatalsrv {
    namespace {
        ThreadContextAccessor g_DefaultThreadContextAccessor;
    }
    void ThreadContextAccessor::SetTaskThreadFlag(bool isTaskThread) NN_NOEXCEPT
    {
        m_Tls.SetValue(isTaskThread ? 1 : 0);
    }

    bool ThreadContextAccessor::IsTaskThread() NN_NOEXCEPT
    {
        return m_Tls.GetValue() != 0 ? true : false;
    }

    ThreadContextAccessor* GetDefaultThreadContextAccessor() NN_NOEXCEPT
    {
        return &g_DefaultThreadContextAccessor;
    }
}} // namespace nn::fatalsrv
