﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkLog.h>
#include <nn/nn_SdkAssert.h>
#include <nn/settings/system/settings_SystemApplication.h>
#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>
#include "fatalsrv_Environment.h"

namespace nn { namespace fatalsrv {
    namespace {
        EnvironmentInfo g_EnvironmentInfo = {};
        bool g_EnvironmentInfoInitialized = false;
    }
    void InitializeEnvironmentInfo() NN_NOEXCEPT
    {
        NN_SDK_ASSERT(!g_EnvironmentInfoInitialized);
#if defined(NN_BUILD_CONFIG_OS_HORIZON)
        nn::settings::system::GetSerialNumber(&g_EnvironmentInfo.serialNumber);
        nn::settings::system::GetFirmwareVersion(&g_EnvironmentInfo.firmwareVersion);
        nn::settings::GetLanguageCode(&g_EnvironmentInfo.languageCode);
        nn::settings::fwdbg::GetSettingsItemValue(
            &g_EnvironmentInfo.transitionToFatal, sizeof(g_EnvironmentInfo.transitionToFatal), "fatal", "transition_to_fatal");
        nn::settings::fwdbg::GetSettingsItemValue(
            &g_EnvironmentInfo.showExtraInfo, sizeof(g_EnvironmentInfo.showExtraInfo), "fatal", "show_extra_info");
        nn::settings::fwdbg::GetSettingsItemValue(
            &g_EnvironmentInfo.questRebootIntervalSecond, sizeof(g_EnvironmentInfo.questRebootIntervalSecond), "fatal", "quest_reboot_interval_second");
        g_EnvironmentInfo.questFlag = nn::settings::system::GetQuestFlag();
#else
        g_EnvironmentInfo.transitionToFatal = true;
#endif
        g_EnvironmentInfoInitialized = true;
    }

    void UpdateLanguageCode() NN_NOEXCEPT
    {
        NN_SDK_ASSERT(g_EnvironmentInfoInitialized);
        nn::settings::GetLanguageCode(&g_EnvironmentInfo.languageCode);
    }

    const EnvironmentInfo& GetEnvironmentInfo() NN_NOEXCEPT
    {
        NN_SDK_ASSERT(g_EnvironmentInfoInitialized);
        return g_EnvironmentInfo;
    }
}} // namespace nn::fatalsrv
