﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/fatalsrv/fatalsrv_CpuContext.h>

#include "fatal_CpuContext.h"

namespace nn { namespace fatal { namespace detail {
    void FillCpuContext(fatalsrv::CpuContext* out) NN_NOEXCEPT
    {
        *out = {};
    }

    void FillCpuContextFromUserExceptionInfo(fatalsrv::CpuContext* out, const nn::os::UserExceptionInfo* exceptionInfo) NN_NOEXCEPT
    {
        NN_UNUSED(exceptionInfo);

        *out = {};
    }
}}} // namespace nn::fatal
