﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>

#include <nn/nn_Common.h>

#include <nn/fan/detail/fan_Log.h>

#include "fan_SettingsHolder.h"

namespace nn { namespace fan { namespace impl { namespace detail {

SettingsHolder::SettingsHolder() NN_NOEXCEPT : m_HasCpuFan(false), m_CpuFanInterface(FanInterface::Invalid)
{
    // 何も処理をしない。
}

void SettingsHolder::LoadSettings() NN_NOEXCEPT
{
#if defined(NN_BUILD_CONFIG_HARDWARE_NX)
    const size_t FanInterfaceBufferSize = 32;
    char cpuFanInterface[FanInterfaceBufferSize] = "\0";

    m_FirmwareDebugSettingsAccessor.ReadSetting(&m_HasCpuFan, "has_cpu_fan", "platformconfig");

    m_FirmwareDebugSettingsAccessor.ReadSettingString(cpuFanInterface, FanInterfaceBufferSize, "cpu_fan_interface", "platformconfig");
    if ( std::strcmp(cpuFanInterface, "pwm") == 0 )
    {
        m_CpuFanInterface = FanInterface::Pwm;
    }
    else if ( std::strcmp(cpuFanInterface, "gpio") == 0 )
    {
        m_CpuFanInterface = FanInterface::Gpio;
    }
    else
    {
        m_CpuFanInterface = FanInterface::Invalid;
    }

    NN_DETAIL_FAN_TRACE("cpu_fan_interface : %s(%d)\n", cpuFanInterface, m_CpuFanInterface);
    NN_DETAIL_FAN_TRACE("has_cpu_fan       : %s\n", m_HasCpuFan ? "true" : "false");
#else
    // NX 以外の HW では Settings の内容が未定義
#endif
}

bool SettingsHolder::HasFan(FanName name) NN_NOEXCEPT
{
    if (name == FanName_Cpu)
    {
        return m_HasCpuFan;
    }
    return false;
}

SettingsHolder::FanInterface SettingsHolder::GetFanInterface(FanName name) NN_NOEXCEPT
{
    if (name == FanName_Cpu)
    {
        return m_CpuFanInterface;
    }
    return FanInterface::Invalid;
}

}}}} // namespace nn::fan::impl
