﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <mutex>
#include <nn/os.h>

#include <nn/nn_Common.h>

#include <nn/gpio/gpio.h>

#include <nn/fan/fan_ControlTypes.h>

#include "fan_DeviceAccessorBase.h"

namespace nn {
namespace fan {
namespace impl {
namespace detail {

class DeviceAccessorGpio : DeviceAccessor
{
    NN_DISALLOW_COPY(DeviceAccessorGpio);
    NN_DISALLOW_MOVE(DeviceAccessorGpio);

public:
    explicit DeviceAccessorGpio(FanName name) NN_NOEXCEPT;

    virtual void SetTargetRotationRate(int rotationRate) NN_NOEXCEPT;
    virtual void SetFanEnabled(bool enabled) NN_NOEXCEPT;
    virtual void SetFanEnabledFromServer(bool enabled) NN_NOEXCEPT;

private:
    void UpdateGpio() NN_NOEXCEPT;

    nn::gpio::GpioPadSession m_GpioPadSessionFanEn;
    nn::gpio::GpioPadSession m_GpioPadSessionPwmFan;
    bool m_Enabled;
    nn::os::Mutex m_Mutex;
};

} // detail
} // impl
} // fan
} // nn
